/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.expression;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public abstract class ExpressionNode
implements Serializable,
Cloneable {
    private ExpressionNode leftNode;
    private ExpressionNode rightNode;

    public ExpressionNode getLeft() {
        return this.leftNode;
    }

    public ExpressionNode getRight() {
        return this.rightNode;
    }

    public void setLeft(ExpressionNode node) {
        this.leftNode = node;
    }

    public void setRight(ExpressionNode node) {
        this.rightNode = node;
    }

    public void getKernelOperandsMIDs(Set s) {
        if (this.leftNode != null) {
            this.leftNode.getKernelOperandsMIDs(s);
        }
        if (this.rightNode != null) {
            this.rightNode.getKernelOperandsMIDs(s);
        }
    }

    public void changeKernelOperandsMIDs(Map idMap) {
        if (this.leftNode != null) {
            this.leftNode.changeKernelOperandsMIDs(idMap);
        }
        if (this.rightNode != null) {
            this.rightNode.changeKernelOperandsMIDs(idMap);
        }
    }

    public void keepKernelOperandsRemoteMIDs(Map idMap) {
        if (this.leftNode != null) {
            this.leftNode.keepKernelOperandsRemoteMIDs(idMap);
        }
        if (this.rightNode != null) {
            this.rightNode.keepKernelOperandsRemoteMIDs(idMap);
        }
    }

    public abstract String getDescription();

    public abstract double getValue();

    public boolean hasAllKernelOperandsDefined() {
        boolean ret1 = this.leftNode != null ? this.leftNode.hasAllKernelOperandsDefined() : true;
        if (!ret1) {
            return false;
        }
        boolean ret2 = this.rightNode != null ? this.rightNode.hasAllKernelOperandsDefined() : true;
        return ret2;
    }

    public Object clone() {
        try {
            ExpressionNode node = (ExpressionNode)super.clone();
            if (this.leftNode != null) {
                node.leftNode = (ExpressionNode)this.leftNode.clone();
            }
            if (this.rightNode != null) {
                node.rightNode = (ExpressionNode)this.rightNode.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        String nodes = this.leftNode != null ? this.leftNode.getDescription() : "null";
        nodes = String.valueOf(nodes) + (this.rightNode != null ? "," + this.rightNode.getDescription() : ",null");
        return String.valueOf(this.getDescription()) + " => (" + nodes + ")" + (this.leftNode != null ? "\n" + this.leftNode : "") + (this.rightNode != null ? "\n" + this.rightNode : "\n");
    }
}

