/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.expression;

import br.ufrj.labma.enibam.kernel.exception.OperatorException;
import br.ufrj.labma.enibam.kernel.exception.UndefinedOperationException;
import br.ufrj.labma.enibam.kernel.expression.ExpressionNode;

public class Operator
extends ExpressionNode
implements Cloneable {
    public static final int OPER_MAIS = 1001;
    public static final int OPER_MENOS = 1002;
    public static final int OPER_VEZES = 1003;
    public static final int OPER_DIV = 1004;
    public static final int OPER_CIRCUNFLEXO = 1006;
    public static final int OPER_MOD = 1007;
    public static final int OPER_SIN = 2001;
    public static final int OPER_COS = 2002;
    public static final int OPER_TAN = 2003;
    public static final int OPER_EXP = 2004;
    public static final int OPER_LN = 2005;
    public static final int OPER_SQRT = 2006;
    public static final int OPER_LOG = 2007;
    public static final int OPER_ABS = 2008;
    public static final int OPER_UNI_MENOS = 3009;
    public static final int OPEN_PAR = 3010;
    public static final int CLOSE_PAR = 3011;
    private int myOperator;

    public Operator(int oper) {
        this.myOperator = oper;
    }

    public void setOperator(int oper) {
        this.myOperator = oper;
    }

    public int getOperator() {
        return this.myOperator;
    }

    public double getValue() {
        ExpressionNode left = this.getLeft();
        ExpressionNode right = this.getRight();
        double rvalue = right.getValue();
        switch (this.myOperator) {
            case 1001: {
                return left.getValue() + rvalue;
            }
            case 1002: {
                return left.getValue() - rvalue;
            }
            case 1003: {
                return left.getValue() * rvalue;
            }
            case 1004: {
                if (rvalue == 0.0) {
                    throw new UndefinedOperationException("Divis\u00e3o por zero!");
                }
                return left.getValue() / rvalue;
            }
            case 1006: {
                double rleft = left.getValue();
                int _x = (int)rvalue;
                if (rleft < 0.0 && rvalue != (double)_x) {
                    throw new UndefinedOperationException("Opera\u00e7\u00e3o indefinida!");
                }
                double result = Math.pow(Math.abs(rleft), rvalue);
                if (rleft < 0.0) {
                    return rvalue % 2.0 == 0.0 ? result : -result;
                }
                return result;
            }
            case 1007: {
                return left.getValue() % rvalue;
            }
            case 2001: {
                return Math.sin(rvalue);
            }
            case 2002: {
                return Math.cos(rvalue);
            }
            case 2003: {
                if (rvalue % Math.PI == 1.5707963267948966) {
                    throw new UndefinedOperationException("Tangente indefinida!");
                }
                return Math.tan(rvalue);
            }
            case 2004: {
                return Math.exp(rvalue);
            }
            case 2005: {
                if (rvalue <= 0.0) {
                    throw new UndefinedOperationException("Logaritmo indefinido!");
                }
                return Math.log(rvalue);
            }
            case 2006: {
                return Math.sqrt(rvalue);
            }
            case 2007: {
                if (rvalue <= 0.0) {
                    throw new UndefinedOperationException("Logaritmo indefinido!");
                }
                return Math.log(rvalue) / Math.log(10.0);
            }
            case 2008: {
                return Math.abs(rvalue);
            }
            case 3009: {
                return -rvalue;
            }
        }
        throw new OperatorException("Operador n\u00e3o encontrado");
    }

    public boolean isOpenType() {
        return this.myOperator == 3010;
    }

    public boolean isCloseType() {
        return this.myOperator == 3011;
    }

    public boolean isUnitaryOperator() {
        return this.myOperator > 2000;
    }

    public boolean isBinaryOperator() {
        return this.myOperator < 2000;
    }

    public boolean isFunctionOperator() {
        return this.myOperator > 2000 && this.myOperator < 3000;
    }

    public String getDescription() {
        switch (this.myOperator) {
            case 1001: {
                return "+";
            }
            case 1002: {
                return "-";
            }
            case 1003: {
                return "*";
            }
            case 1004: {
                return "/";
            }
            case 1006: {
                return "^";
            }
            case 1007: {
                return "%";
            }
            case 2001: {
                return "sen";
            }
            case 2002: {
                return "cos";
            }
            case 2003: {
                return "tan";
            }
            case 2004: {
                return "exp";
            }
            case 2005: {
                return "ln";
            }
            case 2006: {
                return "sqrt";
            }
            case 2007: {
                return "log";
            }
            case 2008: {
                return "abs";
            }
            case 3009: {
                return "-";
            }
            case 3010: {
                return "(";
            }
            case 3011: {
                return ")";
            }
        }
        throw new OperatorException("Operador n\u00e3o encontrado");
    }

    public static final Operator getOperator(String name) {
        if (name.equals("+")) {
            return new Operator(1001);
        }
        if (name.equals("-")) {
            return new Operator(1002);
        }
        if (name.equals("*")) {
            return new Operator(1003);
        }
        if (name.equals("/")) {
            return new Operator(1004);
        }
        if (name.equals("^")) {
            return new Operator(1006);
        }
        if (name.equals("%")) {
            return new Operator(1007);
        }
        if (name.equals("sen")) {
            return new Operator(2001);
        }
        if (name.equals("cos")) {
            return new Operator(2002);
        }
        if (name.equals("tan")) {
            return new Operator(2003);
        }
        if (name.equals("exp")) {
            return new Operator(2004);
        }
        if (name.equals("ln")) {
            return new Operator(2005);
        }
        if (name.equals("sqrt")) {
            return new Operator(2006);
        }
        if (name.equals("log")) {
            return new Operator(2007);
        }
        if (name.equals("abs")) {
            return new Operator(2008);
        }
        if (name.equals("-")) {
            return new Operator(3009);
        }
        if (name.equals("(")) {
            return new Operator(3010);
        }
        if (name.equals(")")) {
            return new Operator(3011);
        }
        throw new OperatorException("Operador n\u00e3o encontrado");
    }

    public int compare(Operator token) {
        return this.precedenceValue() == token.precedenceValue() ? 0 : (this.precedenceValue() > token.precedenceValue() ? 1 : -1);
    }

    private int precedenceValue() {
        switch (this.myOperator) {
            case 1001: {
                return 4;
            }
            case 1002: {
                return 4;
            }
            case 1007: {
                return 4;
            }
            case 1003: {
                return 5;
            }
            case 1004: {
                return 5;
            }
            case 1006: {
                return 6;
            }
            case 2001: {
                return 7;
            }
            case 2002: {
                return 7;
            }
            case 2003: {
                return 7;
            }
            case 2004: {
                return 7;
            }
            case 2005: {
                return 7;
            }
            case 2006: {
                return 7;
            }
            case 2007: {
                return 7;
            }
            case 2008: {
                return 7;
            }
            case 3009: {
                return 7;
            }
            case 3010: {
                return 2;
            }
            case 3011: {
                return 2;
            }
        }
        throw new OperatorException("Operador n\u00e3o encontrado");
    }

    public Object clone() {
        Operator node = (Operator)super.clone();
        if (this.getLeft() != null) {
            node.setLeft((ExpressionNode)this.getLeft().clone());
        }
        if (this.getRight() != null) {
            node.setRight((ExpressionNode)this.getRight().clone());
        }
        return node;
    }
}

