/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.operations;

import br.ufrj.labma.enibam.kernel.KernelArc;
import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelGenericLine;
import br.ufrj.labma.enibam.kernel.dummy.KernelDummyGenericLine;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Distance;
import br.ufrj.labma.enibam.util.MathVector;

public final class Intersection {
    public static boolean InterLines(CoorSys A1, MathVector V1, CoorSys A2, MathVector V2, CoorSys res) {
        double c1 = A1.itsY * V1.getX() - A1.itsX * V1.getY();
        double c2 = A2.itsY * V2.getX() - A2.itsX * V2.getY();
        double d = V1.getX() * V2.getY() - V1.getY() * V2.getX();
        if (Math.abs(d) < 1.0E-5) {
            res.itsX = V1.getX();
            res.itsY = V2.getX();
            res.itsDefinedStatus = false;
            return false;
        }
        res.itsX = (c1 * V2.getX() - V1.getX() * c2) / d;
        res.itsY = (c1 * V2.getY() - V1.getY() * c2) / d;
        res.itsDefinedStatus = true;
        return true;
    }

    public static boolean InterLines(CoorSys A1, CoorSys B1, CoorSys A2, CoorSys B2, CoorSys res) {
        return Intersection.InterLines(A1, new MathVector(A1, B1), A2, new MathVector(A2, B2), res);
    }

    public static boolean InterLineCircle(CoorSys A, MathVector V, CoorSys O, double r, CoorSys I1, CoorSys I2) {
        CoorSys VP = new CoorSys(V.getY(), -V.getX());
        double n2 = VP.itsX * VP.itsX + VP.itsY * VP.itsY;
        double pscal = (A.itsX - O.itsX) * VP.itsX + (A.itsY - O.itsY) * VP.itsY;
        CoorSys u = new CoorSys(pscal * VP.itsX / n2, pscal * VP.itsY / n2);
        double coef = n2 * r * r - pscal * pscal;
        if (coef > -1.0E-5) {
            if (coef < 0.0) {
                coef = 0.0;
            }
            double cord = Math.sqrt(coef) / n2;
            CoorSys v = new CoorSys(cord * V.getX(), cord * V.getY());
            I1.itsX = O.itsX + u.itsX + v.itsX;
            I1.itsY = O.itsY + u.itsY + v.itsY;
            I2.itsX = O.itsX + u.itsX - v.itsX;
            I2.itsY = O.itsY + u.itsY - v.itsY;
            I1.itsDefinedStatus = true;
            I2.itsDefinedStatus = true;
            return true;
        }
        I1.itsDefinedStatus = false;
        I2.itsDefinedStatus = false;
        return false;
    }

    public static boolean InterCircles(CoorSys O1, CoorSys M1, CoorSys O2, CoorSys M2, CoorSys I1, CoorSys I2) {
        double r1q = (M1.itsX - O1.itsX) * (M1.itsX - O1.itsX) + (M1.itsY - O1.itsY) * (M1.itsY - O1.itsY);
        double r2q = (M2.itsX - O2.itsX) * (M2.itsX - O2.itsX) + (M2.itsY - O2.itsY) * (M2.itsY - O2.itsY);
        return Intersection.InterCircles(O1, r1q, O2, r1q, I1, I2);
    }

    public static final void getIntersection(KernelGenericLine s, KernelGenericLine r, CoorSys I) {
        double _b2;
        double _a1 = s.getY1() - s.getY2();
        double _b1 = s.getX2() - s.getX1();
        double _a2 = r.getY1() - r.getY2();
        double _d = _a2 * _b1 - _a1 * (_b2 = r.getX2() - r.getX1());
        if (Math.abs(_d) > 1.0E-5) {
            double _c1 = s.getX1() * s.getY2() - s.getX2() * s.getY1();
            double _c2 = r.getX1() * r.getY2() - r.getX2() * r.getY1();
            double _d1 = _c1 * _b2 - _c2 * _b1;
            double _d2 = _a1 * _c2 - _a2 * _c1;
            I.itsX = _d1 / _d;
            I.itsY = _d2 / _d;
            if (s.contains(I) && r.contains(I)) {
                I.itsDefinedStatus = true;
                return;
            }
        }
        I.itsDefinedStatus = false;
    }

    public static final void getIntersection(KernelDummyGenericLine s, KernelDummyGenericLine r, CoorSys I) {
        double _b2;
        double _a1 = s.getY1() - s.getY2();
        double _b1 = s.getX2() - s.getX1();
        double _a2 = r.getY1() - r.getY2();
        double _d = _a2 * _b1 - _a1 * (_b2 = r.getX2() - r.getX1());
        if (Math.abs(_d) > 1.0E-5) {
            double _c1 = s.getX1() * s.getY2() - s.getX2() * s.getY1();
            double _c2 = r.getX1() * r.getY2() - r.getX2() * r.getY1();
            double _d1 = _c1 * _b2 - _c2 * _b1;
            double _d2 = _a1 * _c2 - _a2 * _c1;
            I.itsX = _d1 / _d;
            I.itsY = _d2 / _d;
            if (s.contains(I) && r.contains(I)) {
                I.itsDefinedStatus = true;
                return;
            }
        }
        I.itsDefinedStatus = false;
    }

    public static final void getIntersection(KernelCircle c1, KernelCircle c2, CoorSys I1, CoorSys I2) {
        double x1 = c1.getCenterX();
        double y1 = c1.getCenterY();
        double r1 = c1.getRadius();
        double x2 = c2.getCenterX();
        double y2 = c2.getCenterY();
        double r2 = c2.getRadius();
        double d = Distance.getDistance(x1, y1, x2, y2);
        if (d >= Math.abs(r1 - r2) && d <= r1 + r2) {
            double u = (d * d + r1 * r1 - r2 * r2) / (2.0 * d);
            double v = -1.0 * Math.sqrt(r1 * r1 - u * u);
            double V = Math.sqrt(r1 * r1 - u * u);
            double ix = x1 + ((x2 - x1) * u + (y2 - y1) * v) / d;
            double iy = y1 - ((y1 - y2) * u + (x2 - x1) * v) / d;
            double Ix = x1 + ((x2 - x1) * u + (y2 - y1) * V) / d;
            double Iy = y1 - ((y1 - y2) * u + (x2 - x1) * V) / d;
            I1.itsX = Ix;
            I1.itsY = Iy;
            I1.itsDefinedStatus = true;
            I2.itsX = ix;
            I2.itsY = iy;
            I2.itsDefinedStatus = true;
        } else {
            I1.itsDefinedStatus = false;
            I2.itsDefinedStatus = false;
        }
    }

    public static final void getIntersection(KernelArc a1, KernelArc a2, CoorSys I1, CoorSys I2) {
        double x1 = a1.getCenterX();
        double y1 = a1.getCenterY();
        double r1 = a1.getRadius();
        double x2 = a2.getCenterX();
        double y2 = a2.getCenterY();
        double r2 = a2.getRadius();
        double d = Distance.getDistance(x1, y1, x2, y2);
        if (d >= Math.abs(r1 - r2) && d <= r1 + r2) {
            double u = (d * d + r1 * r1 - r2 * r2) / (2.0 * d);
            double v = -1.0 * Math.sqrt(r1 * r1 - u * u);
            double V = Math.sqrt(r1 * r1 - u * u);
            double ix = x1 + ((x2 - x1) * u + (y2 - y1) * v) / d;
            double iy = y1 - ((y1 - y2) * u + (x2 - x1) * v) / d;
            double Ix = x1 + ((x2 - x1) * u + (y2 - y1) * V) / d;
            double Iy = y1 - ((y1 - y2) * u + (x2 - x1) * V) / d;
            if (a1.contains(Ix, Iy) && a2.contains(Ix, Iy)) {
                I1.itsX = Ix;
                I1.itsY = Iy;
                I1.itsDefinedStatus = true;
            } else {
                I1.itsDefinedStatus = false;
            }
            if (a1.contains(ix, iy) && a2.contains(ix, iy)) {
                I2.itsX = ix;
                I2.itsY = iy;
                I2.itsDefinedStatus = true;
            } else {
                I2.itsDefinedStatus = false;
            }
        } else {
            I1.itsDefinedStatus = false;
            I2.itsDefinedStatus = false;
        }
    }

    public static final void getIntersection(KernelArc a1, KernelCircle c2, CoorSys I1, CoorSys I2) {
        double x1 = a1.getCenterX();
        double y1 = a1.getCenterY();
        double r1 = a1.getRadius();
        double x2 = c2.getCenterX();
        double y2 = c2.getCenterY();
        double r2 = c2.getRadius();
        double d = Distance.getDistance(x1, y1, x2, y2);
        if (d >= Math.abs(r1 - r2) && d <= r1 + r2) {
            double u = (d * d + r1 * r1 - r2 * r2) / (2.0 * d);
            double v = -1.0 * Math.sqrt(r1 * r1 - u * u);
            double V = Math.sqrt(r1 * r1 - u * u);
            double ix = x1 + ((x2 - x1) * u + (y2 - y1) * v) / d;
            double iy = y1 - ((y1 - y2) * u + (x2 - x1) * v) / d;
            double Ix = x1 + ((x2 - x1) * u + (y2 - y1) * V) / d;
            double Iy = y1 - ((y1 - y2) * u + (x2 - x1) * V) / d;
            if (a1.contains(Ix, Iy)) {
                I1.itsX = Ix;
                I1.itsY = Iy;
                I1.itsDefinedStatus = true;
            } else {
                I1.itsDefinedStatus = false;
            }
            if (a1.contains(ix, iy)) {
                I2.itsX = ix;
                I2.itsY = iy;
                I2.itsDefinedStatus = true;
            } else {
                I2.itsDefinedStatus = false;
            }
        } else {
            I1.itsDefinedStatus = false;
            I2.itsDefinedStatus = false;
        }
    }

    public static boolean InterCircles(CoorSys C1, double radius1, CoorSys C2, double radius2, CoorSys I1, CoorSys I2) {
        double x1 = C1.itsX;
        double y1 = C1.itsY;
        double r1 = radius1;
        double x2 = C2.itsX;
        double y2 = C2.itsY;
        double r2 = radius2;
        double d = Distance.getDistance(x1, y1, x2, y2);
        if (d >= Math.abs(r1 - r2) && d <= r1 + r2) {
            double u = (d * d + r1 * r1 - r2 * r2) / (2.0 * d);
            double v = -1.0 * Math.sqrt(r1 * r1 - u * u);
            double V = Math.sqrt(r1 * r1 - u * u);
            double ix = x1 + ((x2 - x1) * u + (y2 - y1) * v) / d;
            double iy = y1 - ((y1 - y2) * u + (x2 - x1) * v) / d;
            double Ix = x1 + ((x2 - x1) * u + (y2 - y1) * V) / d;
            double Iy = y1 - ((y1 - y2) * u + (x2 - x1) * V) / d;
            I1.itsX = Ix;
            I1.itsY = Iy;
            I1.itsDefinedStatus = true;
            I2.itsX = ix;
            I2.itsY = iy;
            I2.itsDefinedStatus = true;
            return true;
        }
        I1.itsDefinedStatus = false;
        I2.itsDefinedStatus = false;
        return false;
    }
}

