/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.operations;

import br.ufrj.labma.enibam.kernel.operations.MatrixException;

public class Matrix {
    private int nCollumns;
    private int nRows;
    private double[][] elements;

    public Matrix(int n) throws MatrixException {
        this(n, n);
    }

    public Matrix(int n, int m) throws MatrixException {
        if (n < 1 || m < 1) {
            throw new MatrixException("Erro ao tentar criar uma matriz: " + n + " x " + m);
        }
        if (n + m < 3) {
            throw new MatrixException("Erro ao tentar criar uma matriz de tamanho: " + n + " x " + m);
        }
        this.nRows = n;
        this.nCollumns = m;
        this.elements = new double[n][m];
    }

    public Matrix(int n, double[][] elements) throws MatrixException {
        this(n, n, elements);
    }

    public Matrix(int n, int m, double[][] elements) throws MatrixException {
        this(n, m);
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                this.elements[i][j] = elements[i][j];
                ++j;
            }
            ++i;
        }
    }

    private double det_3x3_sarrus() throws MatrixException {
        if (this.nCollumns != 3 || this.nRows != 3) {
            throw new MatrixException("Formato invalido da matriz. Matriz deve ser 3 x 3 mas \u00e9 " + this.nRows + " x " + this.nCollumns);
        }
        double add_part1 = this.elements[0][0] * this.elements[1][1] * this.elements[2][2];
        double add_part2 = this.elements[0][1] * this.elements[1][2] * this.elements[2][0];
        double add_part3 = this.elements[0][2] * this.elements[1][0] * this.elements[2][1];
        double sub_part1 = this.elements[0][2] * this.elements[1][1] * this.elements[2][0];
        double sub_part2 = this.elements[0][0] * this.elements[1][2] * this.elements[2][1];
        double sub_part3 = this.elements[0][1] * this.elements[1][0] * this.elements[2][2];
        return add_part1 + add_part2 + add_part3 - sub_part1 - sub_part2 - sub_part3;
    }

    private double det_2x2() throws MatrixException {
        if (this.nCollumns != 2 || this.nRows != 2) {
            throw new MatrixException("Formato invalido da matriz. Matriz deve ser 2 x 2 mas \u00e9 " + this.nRows + " x " + this.nCollumns);
        }
        return this.elements[0][0] * this.elements[1][1] - this.elements[0][1] * this.elements[1][0];
    }

    public Matrix removeRow(int n) throws MatrixException {
        if (n < 0 || n >= this.nRows) {
            throw new MatrixException("Linha invalida da matriz. A linha requisitada foi: " + n + " e a matriz tem dimens\u00f5es: " + this.nRows + " x " + this.nCollumns);
        }
        double[][] newElements = new double[this.nRows - 1][this.nCollumns];
        int i_index = 0;
        int j_index = 0;
        int i = 0;
        while (i < this.nRows) {
            if (i != n) {
                int j = 0;
                while (j < this.nCollumns) {
                    newElements[i_index][j_index++] = this.elements[i][j];
                    ++j;
                }
                ++i_index;
            }
            ++i;
        }
        return new Matrix(this.nRows - 1, this.nCollumns, newElements);
    }

    public Matrix removeCollumn(int m) throws MatrixException {
        if (m < 0 || m >= this.nCollumns) {
            throw new MatrixException("Colunaa invalida da matriz. A coluna requisitada foi: " + m + " e a matriz tem dimens\u00f5es: " + this.nRows + " x " + this.nCollumns);
        }
        double[][] newElements = new double[this.nRows][this.nCollumns - 1];
        int i_index = 0;
        int j_index = 0;
        int i = 0;
        while (i < this.nRows) {
            int j = 0;
            while (j < this.nCollumns) {
                if (j != m) {
                    newElements[i_index][j_index++] = this.elements[i][j];
                }
                ++j;
            }
            ++i_index;
            ++i;
        }
        return new Matrix(this.nRows, this.nCollumns - 1, newElements);
    }

    public double det() throws MatrixException {
        if (this.nRows != this.nCollumns) {
            throw new MatrixException("Formato invalido da matriz. Matriz deve ser quadrada (n x n) mas \u00e9 " + this.nRows + " x " + this.nCollumns);
        }
        if (this.nRows == 2) {
            return this.det_2x2();
        }
        if (this.nRows == 3) {
            return this.det_3x3_sarrus();
        }
        double det = 0.0;
        int i = 0;
        while (i < this.nRows) {
            double partn = i % 2 == 0 ? -1 : 1;
            partn *= this.elements[i][0];
            det += (partn *= this.removeCollumn(0).removeRow(i).det());
            ++i;
        }
        return det;
    }

    public Matrix add(Matrix matrix) throws MatrixException {
        if (this.nCollumns != matrix.nCollumns || this.nRows != matrix.nRows) {
            throw new MatrixException("As matrizes s\u00e3o de tipos diferentes. A matriz 1: " + this.nRows + " x " + this.nCollumns + " e a matriz 2: " + matrix.nRows + " x " + this.nCollumns);
        }
        Matrix addMatrix = new Matrix(this.nRows, this.nCollumns, this.elements);
        int i = 0;
        while (i < addMatrix.nRows) {
            int j = 0;
            while (j < addMatrix.nCollumns) {
                double[] dArray = addMatrix.elements[i];
                int n = j;
                dArray[n] = dArray[n] + this.elements[i][j];
                ++j;
            }
            ++i;
        }
        return addMatrix;
    }

    public Matrix mult(Matrix matrix) throws MatrixException {
        if (this.nCollumns != matrix.nRows) {
            throw new MatrixException("As matrizes n\u00e3o podem ser multiplicadas.  A matriz 1: " + this.nRows + " x " + this.nCollumns + " e a matriz 2: " + matrix.nRows + " x " + matrix.nCollumns);
        }
        Matrix prod = new Matrix(this.nRows, matrix.nCollumns);
        int i = 0;
        while (i < prod.nRows) {
            int j = 0;
            while (j < prod.nCollumns) {
                prod.elements[i][j] = 0.0;
                int k = 0;
                while (k < this.nCollumns) {
                    double[] dArray = prod.elements[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.elements[i][k] * matrix.elements[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return prod;
    }

    public Matrix mult(double x) {
        Matrix prod = new Matrix(this.nRows, this.nCollumns, this.elements);
        int i = 0;
        while (i < prod.nRows) {
            int j = 0;
            while (j < prod.nCollumns) {
                double[] dArray = prod.elements[i];
                int n = j++;
                dArray[n] = dArray[n] * x;
            }
            ++i;
        }
        return prod;
    }

    public Matrix transpost() {
        Matrix transpost = new Matrix(this.nCollumns, this.nRows);
        int i = 0;
        while (i < transpost.nRows) {
            int j = 0;
            while (j < transpost.nCollumns) {
                transpost.elements[i][j] = this.elements[j][i];
                ++j;
            }
            ++i;
        }
        return transpost;
    }

    public static Matrix nullMatrix(int n, int m) throws MatrixException {
        return new Matrix(n, m);
    }

    public static Matrix identity(int n) {
        Matrix identity = new Matrix(n);
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                identity.elements[i][j] = i == j ? 1 : 0;
                ++j;
            }
            ++i;
        }
        return identity;
    }

    private Matrix inverse_3x3() throws MatrixException {
        if (this.nCollumns != 3 || this.nRows != 3) {
            throw new MatrixException("Erro: Matrix precisa ser do tipo: 3 x 3");
        }
        Matrix result = new Matrix(3);
        result.elements[0][0] = this.elements[1][1] - this.elements[1][2];
        result.elements[0][1] = -this.elements[0][1] + this.elements[0][2];
        result.elements[0][2] = this.elements[0][1] * this.elements[1][2] - this.elements[0][2] * this.elements[1][1];
        result.elements[1][0] = -this.elements[1][0] + this.elements[1][2];
        result.elements[1][1] = this.elements[0][0] - this.elements[0][2];
        result.elements[1][2] = -(this.elements[0][0] * this.elements[1][2]) + this.elements[1][0] * this.elements[0][2];
        result.elements[2][0] = this.elements[1][0] - this.elements[1][1];
        result.elements[2][1] = -this.elements[0][0] + this.elements[0][1];
        result.elements[2][2] = this.elements[0][0] * this.elements[1][1] - this.elements[1][0] * this.elements[0][1];
        return result;
    }

    public Matrix inverse() throws MatrixException {
        if (this.nCollumns == 3 || this.nRows == 3) {
            return this.inverse_3x3();
        }
        throw new MatrixException("Erro: Atualmente esta biblioteca apenas suporta matrizes do tipo 3 x 3. A matriz era do tipo: " + this.nRows + " x " + this.nCollumns);
    }

    public int getNumberOfRows() {
        return this.nRows;
    }

    public int getNumberOfCollumns() {
        return this.nCollumns;
    }

    public double elementAt(int n, int m) throws MatrixException {
        if (n < 0 || n >= this.nRows || m < 0 || m >= this.nCollumns) {
            throw new MatrixException("Elemento inv\u00e1lido. A matriz \u00e9 do tipo: " + this.nRows + " x " + this.nCollumns + ". Elemento: " + n + " x " + m);
        }
        return this.elements[n][m];
    }

    public void setElementAt(int n, int m, double value) throws MatrixException {
        if (n < 0 || n >= this.nRows || m < 0 || m >= this.nCollumns) {
            throw new MatrixException("Elemento inv\u00e1lido. A matriz \u00e9 do tipo: " + this.nRows + " x " + this.nCollumns);
        }
        this.elements[n][m] = value;
    }

    public String toString() {
        String matrix = "";
        int i = 0;
        while (i < this.nRows) {
            matrix = String.valueOf(matrix) + "Linha " + (i + 1) + ": [";
            int j = 0;
            while (j < this.nCollumns) {
                matrix = String.valueOf(matrix) + this.elements[i][j];
                if (j < this.nCollumns - 1) {
                    matrix = String.valueOf(matrix) + ", ";
                }
                ++j;
            }
            matrix = String.valueOf(matrix) + "]";
            ++i;
        }
        return matrix;
    }

    public boolean equals(Object o) {
        if (o instanceof Matrix) {
            Matrix matrix = (Matrix)o;
            if (this.nRows == matrix.nRows && this.nCollumns == matrix.nCollumns) {
                int i = 0;
                while (i < this.nRows) {
                    int j = 0;
                    while (j < this.nCollumns) {
                        if (this.elements[i][j] != matrix.elements[i][j]) {
                            return false;
                        }
                        ++j;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

