/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.operations;

import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Distance;
import br.ufrj.labma.enibam.kernel.operations.Intersection;
import br.ufrj.labma.enibam.util.MathVector;
import java.util.Vector;

public class NonEuclidMath {
    public static void ProdComplex(CoorSys z1, CoorSys z2, CoorSys pz1z2) {
        pz1z2.itsX = z1.itsX * z2.itsX - z1.itsY * z2.itsY;
        pz1z2.itsY = z1.itsX * z2.itsY + z1.itsY * z2.itsX;
    }

    public static boolean FracComplex(CoorSys z1, CoorSys z2, CoorSys fz1z2) {
        double mod2 = z2.itsX * z2.itsX + z2.itsY * z2.itsY;
        if (mod2 < 1.0E-5) {
            return false;
        }
        fz1z2.itsX = (z1.itsX * z2.itsX + z1.itsY * z2.itsY) / mod2;
        fz1z2.itsY = (z1.itsY * z2.itsX - z1.itsX * z2.itsY) / mod2;
        return true;
    }

    public static boolean CrossRatio(CoorSys z1, CoorSys z2, CoorSys z3, CoorSys z4, CoorSys cr) {
        CoorSys den = new CoorSys();
        CoorSys num = new CoorSys();
        if (!NonEuclidMath.FracComplex(new CoorSys(z1.itsX - z3.itsX, z1.itsY - z3.itsY), new CoorSys(z1.itsX - z2.itsX, z1.itsY - z2.itsY), num)) {
            return false;
        }
        if (!NonEuclidMath.FracComplex(new CoorSys(z4.itsX - z3.itsX, z4.itsY - z3.itsY), new CoorSys(z4.itsX - z2.itsX, z4.itsY - z2.itsY), den)) {
            return false;
        }
        return NonEuclidMath.FracComplex(num, den, cr);
    }

    public static boolean inversePt(CoorSys A, CoorSys OH, double RH, CoorSys invA) {
        CoorSys AP = (CoorSys)A.clone();
        AP.itsX -= OH.itsX;
        AP.itsY -= OH.itsY;
        double r2 = AP.itsX * AP.itsX + AP.itsY * AP.itsY;
        if (r2 < 1.0E-5) {
            return false;
        }
        double coef = RH * RH / r2;
        invA.itsX = coef * AP.itsX + OH.itsX;
        invA.itsY = coef * AP.itsY + OH.itsY;
        return true;
    }

    public static void fromPoincare2Klein(CoorSys A, CoorSys O, double r) {
        A.itsX -= O.itsX;
        A.itsY -= O.itsY;
        A.itsX /= r;
        A.itsY /= r;
        double fact = 2.0 * r / (1.0 + A.itsX * A.itsX + A.itsY * A.itsY);
        A.itsX = fact * A.itsX + O.itsX;
        A.itsY = fact * A.itsY + O.itsY;
    }

    public static void fromKlein2Poincare(CoorSys A, CoorSys O, double r) {
        if (Math.abs(A.itsX - O.itsX) + Math.abs(A.itsY - O.itsY) > 1.0E-5) {
            A.itsX -= O.itsX;
            A.itsY -= O.itsY;
            A.itsX /= r;
            A.itsY /= r;
            double mod2 = A.itsX * A.itsX + A.itsY * A.itsY;
            double fact = r * (1.0 - Math.sqrt(1.0 - mod2)) / mod2;
            A.itsX = fact * A.itsX + O.itsX;
            A.itsY = fact * A.itsY + O.itsY;
        }
    }

    public static boolean kleinLineHorizonPoints(CoorSys A, CoorSys B, CoorSys O, double R, CoorSys I1, CoorSys I2) {
        MathVector V = new MathVector(A, B);
        return Intersection.InterLineCircle(A, V, O, R, I1, I2);
    }

    public static boolean hypLineHorizonPoints(CoorSys _A, CoorSys _B, CoorSys O, double R, CoorSys H1, CoorSys H2) {
        CoorSys A = (CoorSys)_A.clone();
        CoorSys B = (CoorSys)_B.clone();
        NonEuclidMath.fromPoincare2Klein(A, O, R);
        NonEuclidMath.fromPoincare2Klein(B, O, R);
        return NonEuclidMath.kleinLineHorizonPoints(A, B, O, R, H1, H2);
    }

    public static boolean CrossRatio2HP(CoorSys A, CoorSys B, CoorSys O, double R, CoorSys crhp) {
        CoorSys z4;
        CoorSys z3;
        CoorSys z2;
        CoorSys z1;
        CoorSys I1 = new CoorSys();
        CoorSys I2 = new CoorSys();
        return NonEuclidMath.hypLineHorizonPoints(A, B, O, R, I1, I2) && NonEuclidMath.CrossRatio(z1 = new CoorSys(I2.itsX - O.itsX, I2.itsY - O.itsY), z2 = new CoorSys(A.itsX - O.itsX, A.itsY - O.itsY), z3 = new CoorSys(B.itsX - O.itsX, B.itsY - O.itsY), z4 = new CoorSys(I1.itsX - O.itsX, I1.itsY - O.itsY), crhp);
    }

    public static boolean CrossRatio2KP(CoorSys A, CoorSys B, CoorSys O, double R, CoorSys crhp) {
        CoorSys z4;
        CoorSys z3;
        CoorSys z2;
        CoorSys z1;
        CoorSys I1 = new CoorSys();
        CoorSys I2 = new CoorSys();
        return NonEuclidMath.kleinLineHorizonPoints(A, B, O, R, I1, I2) && NonEuclidMath.CrossRatio(z1 = new CoorSys(I2.itsX - O.itsX, I2.itsY - O.itsY), z2 = new CoorSys(A.itsX - O.itsX, A.itsY - O.itsY), z3 = new CoorSys(B.itsX - O.itsX, B.itsY - O.itsY), z4 = new CoorSys(I1.itsX - O.itsX, I1.itsY - O.itsY), crhp);
    }

    public static boolean poincareLineEuclidianCenter(CoorSys A, CoorSys B, CoorSys OH, double RH, CoorSys LC) {
        CoorSys I = new CoorSys((A.itsX + B.itsX) / 2.0, (A.itsY + B.itsY) / 2.0);
        MathVector V = new MathVector(A, B).orthogonal();
        CoorSys invA = new CoorSys();
        if (!NonEuclidMath.inversePt(A, OH, RH, invA)) {
            return false;
        }
        CoorSys J = new CoorSys((A.itsX + invA.itsX) / 2.0, (A.itsY + invA.itsY) / 2.0);
        MathVector U = new MathVector(J, OH).orthogonal();
        return Intersection.InterLines(I, V, J, U, LC);
    }

    public static boolean poincareLine3pts(CoorSys A, CoorSys B, CoorSys OH, double RH, Vector pts) {
        CoorSys LC = new CoorSys();
        CoorSys I1 = new CoorSys();
        CoorSys I2 = new CoorSys();
        if (NonEuclidMath.hypLineHorizonPoints(A, B, OH, RH, I1, I2) && NonEuclidMath.poincareLineEuclidianCenter(A, B, OH, RH, LC)) {
            CoorSys RI = new CoorSys((A.itsX + B.itsX) / 2.0 - LC.itsX, (A.itsY + B.itsY) / 2.0 - LC.itsY);
            double coef = Math.sqrt(((A.itsX - LC.itsX) * (A.itsX - LC.itsX) + (A.itsY - LC.itsY) * (A.itsY - LC.itsY)) / (RI.itsX * RI.itsX + RI.itsY * RI.itsY));
            RI.itsX = coef * RI.itsX + LC.itsX;
            RI.itsY = coef * RI.itsY + LC.itsY;
            pts.add(I2);
            pts.add(RI);
            pts.add(I1);
            return true;
        }
        return false;
    }

    public static boolean poincareCircleEuclidianCenter(CoorSys _O, CoorSys _M, CoorSys OH, double RH, CoorSys OC) {
        double coef;
        MathVector U;
        CoorSys invO;
        CoorSys J;
        CoorSys O = (CoorSys)_O.clone();
        CoorSys M = (CoorSys)_M.clone();
        if (Math.abs(O.itsX - OH.itsX) + Math.abs(O.itsY - OH.itsY) < 1.0E-5 || Math.abs(O.itsX - M.itsX) + Math.abs(O.itsY - M.itsY) < 1.0E-5) {
            OC.itsX = O.itsX;
            OC.itsY = O.itsY;
            return true;
        }
        O.itsX -= OH.itsX;
        O.itsY -= OH.itsY;
        M.itsX -= OH.itsX;
        M.itsY -= OH.itsY;
        if (Math.abs(O.itsX * M.itsY - O.itsY * M.itsX) < 1.0E-5) {
            double coef2 = RH * RH / (O.itsX * O.itsX + O.itsY * O.itsY);
            CoorSys I = new CoorSys((O.itsX + coef2 * O.itsX) / 2.0, (O.itsY + coef2 * O.itsY) / 2.0);
            coef2 = O.itsX - I.itsX;
            double d = coef2 * coef2;
            coef2 = O.itsY - I.itsY;
            double vx = M.itsX - I.itsX;
            double vy = M.itsY - I.itsY;
            coef2 = (d + coef2 * coef2) / (vx * vx + vy * vy);
            OC.itsX = (coef2 * vx + vx) / 2.0 + I.itsX + OH.itsX;
            OC.itsY = (coef2 * vy + vy) / 2.0 + I.itsY + OH.itsY;
            return true;
        }
        CoorSys I = new CoorSys((O.itsX + M.itsX) / 2.0, (O.itsY + M.itsY) / 2.0);
        MathVector V = new MathVector(O, M).orthogonal();
        if (Intersection.InterLines(I, V, J = new CoorSys((O.itsX + invO.itsX) / 2.0, (O.itsY + invO.itsY) / 2.0), U = new MathVector(O, invO = new CoorSys((coef = RH * RH / (O.itsX * O.itsX + O.itsY * O.itsY)) * O.itsX, coef * O.itsY)).orthogonal(), OC)) {
            V.setVector(OC, M);
            V.orthogonal();
            MathVector VO = new MathVector(O.itsX, O.itsY);
            if (Intersection.InterLines(M, V, O, VO, OC)) {
                OC.itsX += OH.itsX;
                OC.itsY += OH.itsY;
                return true;
            }
        }
        return false;
    }

    public static boolean kleinCircle5Points(CoorSys _O, CoorSys _M, CoorSys OH, double RH, Vector pts) {
        CoorSys O = (CoorSys)_O.clone();
        CoorSys M = (CoorSys)_M.clone();
        NonEuclidMath.fromKlein2Poincare(O, OH, RH);
        NonEuclidMath.fromKlein2Poincare(M, OH, RH);
        CoorSys OC = new CoorSys();
        if (NonEuclidMath.poincareCircleEuclidianCenter(O, M, OH, RH, OC)) {
            M.itsX -= OC.itsX;
            M.itsY -= OC.itsY;
            double c72 = Math.cos(1.2566370614359172);
            double s72 = Math.sin(1.2566370614359172);
            int i = 0;
            while (i < 5) {
                double x = c72 * M.itsX - s72 * M.itsY;
                double y = s72 * M.itsX + c72 * M.itsY;
                CoorSys MSC = new CoorSys(x, y);
                M.itsX = x;
                M.itsY = y;
                MSC.itsX += OC.itsX;
                MSC.itsY += OC.itsY;
                NonEuclidMath.fromPoincare2Klein(MSC, OH, RH);
                pts.addElement(MSC);
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean tangentPoints(CoorSys P, CoorSys OH, double RH, CoorSys T1, CoorSys T2) {
        double delta = 1.0;
        CoorSys V = new CoorSys();
        V.itsX = P.itsX - OH.itsX;
        V.itsY = P.itsY - OH.itsY;
        double dist = Math.sqrt(V.itsX * V.itsX + V.itsY * V.itsY);
        if (RH <= 0.0 + delta && RH >= 0.0 - delta) {
            return false;
        }
        if (dist > RH + delta) {
            V.itsX = (OH.itsX + P.itsX) / 2.0;
            V.itsY = (OH.itsY + P.itsY) / 2.0;
            dist = Math.sqrt((OH.itsX - V.itsX) * (OH.itsX - V.itsX) + (OH.itsY - V.itsY) * (OH.itsY - V.itsY));
            double d = Distance.getDistance(V.itsX, V.itsY, OH.itsX, P.itsY);
            double u = (d * d + dist * dist - RH * RH) / (2.0 * d);
            double v = -1.0 * Math.sqrt(dist * dist - u * u);
            double _V = Math.sqrt(dist * dist - u * u);
            double ix = V.itsX + ((OH.itsX - V.itsX) * u + (OH.itsY - V.itsY) * v) / d;
            double iy = V.itsY - ((V.itsY - OH.itsY) * u + (OH.itsX - V.itsX) * v) / d;
            double Ix = V.itsX + ((OH.itsX - V.itsX) * u + (OH.itsY - V.itsY) * _V) / d;
            double Iy = V.itsY - ((V.itsY - OH.itsY) * u + (OH.itsX - V.itsX) * _V) / d;
            T1.itsX = ix;
            T1.itsY = iy;
            T2.itsX = Ix;
            T2.itsY = Iy;
            return true;
        }
        if (RH + delta >= dist && dist >= RH - delta) {
            T1.itsX = P.itsX;
            T1.itsY = P.itsY;
            T2.itsX = P.itsX;
            T2.itsY = P.itsY;
            return true;
        }
        return false;
    }

    public static boolean poicareLineIntersCircleEuclidian(CoorSys A1, CoorSys A2, CoorSys OH, double RH, CoorSys I) {
        CoorSys CA = new CoorSys();
        NonEuclidMath.poincareLineEuclidianCenter(A1, A2, OH, RH, CA);
        double RA = Distance.getDistance(CA.itsX, CA.itsY, A1.itsX, A1.itsY);
        double d = Distance.getDistance(CA.itsX, CA.itsY, OH.itsX, OH.itsY);
        if (d >= Math.abs(RA - RH) && d <= RA + RH) {
            double u = (d * d + RA * RA - RH * RH) / (2.0 * d);
            double v = -1.0 * Math.sqrt(RA * RA - u * u);
            double V = Math.sqrt(RA * RA - u * u);
            double ix = CA.itsX + ((OH.itsX - CA.itsX) * u + (OH.itsY - CA.itsY) * v) / d;
            double iy = CA.itsY - ((CA.itsY - OH.itsY) * u + (OH.itsX - CA.itsX) * v) / d;
            double Ix = CA.itsX + ((OH.itsX - CA.itsX) * u + (OH.itsY - CA.itsY) * V) / d;
            double Iy = CA.itsY - ((CA.itsY - OH.itsY) * u + (OH.itsX - CA.itsX) * V) / d;
            if (Iy <= A1.itsY && Iy >= A2.itsY || Iy <= A2.itsY && Iy >= A1.itsY) {
                I.itsX = Ix;
                I.itsY = Iy;
                return true;
            }
            if (iy <= A1.itsY && iy >= A2.itsY || iy <= A2.itsY && iy >= A1.itsY) {
                I.itsX = ix;
                I.itsY = iy;
                return true;
            }
            return false;
        }
        return false;
    }

    public static void InterLineCircle(CoorSys a, CoorSys b, CoorSys c, double d, Vector e) {
    }

    public static void euclidianCirclesIntersections(CoorSys a, double d1, CoorSys b, double d2, CoorSys c, CoorSys e) {
    }
}

