/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.operations;

import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Matrix;

public final class PlaneProjection {
    private static final Matrix x = new Matrix(3);
    private static final Matrix col_x = new Matrix(3, 1);
    private static final Matrix y = new Matrix(3);
    private static final Matrix col_y = new Matrix(3, 1);
    private static final double delta = 1.0E-5;
    private static final Matrix B = new Matrix(3);
    private static final Matrix point = new Matrix(3, 1);

    public static final boolean getPointProjected(CoorSys a, CoorSys b, CoorSys c, CoorSys d, CoorSys _a, CoorSys _b, CoorSys _c, CoorSys _d, CoorSys p, CoorSys _p) {
        x.setElementAt(0, 0, a.itsX);
        x.setElementAt(0, 1, b.itsX);
        x.setElementAt(0, 2, c.itsX);
        x.setElementAt(1, 0, a.itsY);
        x.setElementAt(1, 1, b.itsY);
        x.setElementAt(1, 2, c.itsY);
        x.setElementAt(2, 0, 1.0);
        x.setElementAt(2, 1, 1.0);
        x.setElementAt(2, 2, 1.0);
        y.setElementAt(0, 0, _a.itsX);
        y.setElementAt(0, 1, _b.itsX);
        y.setElementAt(0, 2, _c.itsX);
        y.setElementAt(1, 0, _a.itsY);
        y.setElementAt(1, 1, _b.itsY);
        y.setElementAt(1, 2, _c.itsY);
        y.setElementAt(2, 0, 1.0);
        y.setElementAt(2, 1, 1.0);
        y.setElementAt(2, 2, 1.0);
        col_x.setElementAt(0, 0, d.itsX);
        col_x.setElementAt(1, 0, d.itsY);
        col_x.setElementAt(2, 0, 1.0);
        col_y.setElementAt(0, 0, _d.itsX);
        col_y.setElementAt(1, 0, _d.itsY);
        col_y.setElementAt(2, 0, 1.0);
        point.setElementAt(0, 0, p.itsX);
        point.setElementAt(1, 0, p.itsY);
        point.setElementAt(2, 0, 1.0);
        if (Math.abs(x.det()) < 1.0E-5 || Math.abs(y.det()) < 1.0E-5) {
            return false;
        }
        Matrix invX = x.inverse();
        Matrix invY = y.inverse();
        Matrix mulX = invX.mult(col_x);
        Matrix mulY = invY.mult(col_y);
        if (Math.abs(mulX.elementAt(0, 0)) < 1.0E-5 || Math.abs(mulX.elementAt(1, 0)) < 1.0E-5 || Math.abs(mulX.elementAt(2, 0)) < 1.0E-5 || Math.abs(mulY.elementAt(0, 0)) < 1.0E-5 || Math.abs(mulY.elementAt(1, 0)) < 1.0E-5 || Math.abs(mulY.elementAt(2, 0)) < 1.0E-5) {
            return false;
        }
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                if (i == j) {
                    B.setElementAt(i, i, mulY.elementAt(i, 0) / mulX.elementAt(i, 0));
                } else {
                    B.setElementAt(i, j, 0.0);
                }
                ++j;
            }
            ++i;
        }
        Matrix transformation = y.mult(B);
        Matrix pointProjected = (transformation = transformation.mult(x.inverse())).mult(point);
        double w = pointProjected.elementAt(2, 0);
        if (Math.abs(w) < 1.0E-5) {
            return false;
        }
        double u = pointProjected.elementAt(0, 0) / w;
        double v = pointProjected.elementAt(1, 0) / w;
        _p.itsX = u;
        _p.itsY = v;
        return false;
    }

    public static final boolean getPointProjected(CoorSys a, CoorSys b, CoorSys c, CoorSys d, CoorSys _a, CoorSys _b, CoorSys _c, CoorSys _d, CoorSys p) {
        return PlaneProjection.getPointProjected(a, b, c, d, _a, _b, _c, _d, p, p);
    }
}

