/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.state;

import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.AngleState;
import br.ufrj.labma.enibam.kernel.state.AreaState;
import br.ufrj.labma.enibam.kernel.state.LengthState;
import br.ufrj.labma.enibam.kernel.state.PointState;
import br.ufrj.labma.enibam.kernel.state.RatioState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.util.GraphicUtilities;

public class StateConverter {
    private static StateConverter theInstance;
    private CoorSys coorsys = new CoorSys();

    private StateConverter() {
        GraphicUtilities.loadScreenDimension();
    }

    public static final StateConverter getInstance() {
        if (theInstance == null) {
            theInstance = new StateConverter();
        }
        return theInstance;
    }

    public final State toDevice(State state) {
        if (state instanceof PointState) {
            this.coorsys.itsX = ((PointState)state).itsX;
            this.coorsys.itsY = ((PointState)state).itsY;
            ((PointState)state).itsX = this.coorsys.itsX;
            ((PointState)state).itsY = this.coorsys.itsY;
        }
        return state;
    }

    public final State toStream(State state) {
        if (state instanceof PointState) {
            this.coorsys.itsX = ((PointState)state).itsX;
            this.coorsys.itsY = ((PointState)state).itsY;
            ((PointState)state).itsX = this.coorsys.itsX;
            ((PointState)state).itsY = this.coorsys.itsY;
        }
        return state;
    }

    public double getValue(State state) {
        if (state instanceof RatioState) {
            return ((RatioState)state).itsRatio;
        }
        if (state instanceof AngleState) {
            return ((AngleState)state).itsAngle;
        }
        if (state instanceof LengthState) {
            return ((LengthState)state).itsLength;
        }
        if (state instanceof AreaState) {
            return ((AreaState)state).itsArea;
        }
        return 0.0;
    }
}

