/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.macro;

import br.ufrj.labma.enibam.gui.MenuComponentBase;
import br.ufrj.labma.enibam.history.History;
import br.ufrj.labma.enibam.history.ae.MakeElement;
import br.ufrj.labma.enibam.macro.MacroException;
import br.ufrj.labma.enibam.macro.MacroInspector;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Macro
implements Serializable {
    private List theInputList;
    private List theMakeElements;
    private int code;
    private String name;
    private String description;

    public Macro(List elements) throws MacroException {
        if (elements == null || elements.size() == 0) {
            throw new MacroException("O conte\u00fado da macro n\u00e3o foi definido.");
        }
        this.theMakeElements = new ArrayList();
        this.theMakeElements.addAll(elements);
    }

    public void setInputList(List inputs) throws MacroException {
        if (inputs == null || inputs.size() == 0) {
            throw new MacroException("Os inputs da macro n\u00e3o foram definidos.");
        }
        this.theInputList = new ArrayList();
        this.theInputList.addAll(inputs);
    }

    public List getInputList() {
        return this.theInputList;
    }

    public List generateMakeElements() throws MacroException {
        if (!this.validateInputs(this.theInputList)) {
            throw new MacroException("Inputs n\u00e3o s\u00e3o v\u00e1lidos");
        }
        this.theInputList = this.sortedInputs(this.theInputList);
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (MakeElement ae : this.theMakeElements) {
            map.put(new Integer(ae.getObjectID()), new Integer(ae.getObjectID()));
            if (ae.isJokerElement()) continue;
            Object object = ae.clone();
            result.add(object);
            ids.add(new Integer(ae.getObjectID()));
        }
        Iterator j = this.theInputList.iterator();
        while (j.hasNext()) {
            int id = ((MakeElement)j.next()).getObjectID();
            map.put(new Integer(id), this.getNextID(id, ids));
        }
        int j2 = 0;
        for (MakeElement makeElement : this.theMakeElements) {
            if (!makeElement.isJokerElement()) continue;
            map.put(new Integer(makeElement.getObjectID()), new Integer(((MakeElement)this.theInputList.get(j2++)).getObjectID()));
        }
        for (MakeElement makeElement : result) {
            int new_id = (Integer)map.get(new Integer(makeElement.getObjectID()));
            makeElement.setObjectID(new_id);
        }
        for (MakeElement makeElement : result) {
            makeElement.changeParents(map);
            History.changeCalculatorId(map, (MakeElement)makeElement);
        }
        this.theInputList.clear();
        return result;
    }

    private Integer getNextID(int id, List ids) {
        Integer ID = new Integer(id);
        while (ids.contains(ID)) {
            ID = new Integer(ID + 5);
        }
        ids.add(ID);
        return ID;
    }

    public boolean validateInputs(List inputs) throws MacroException {
        block4: {
            if (inputs == null || inputs.size() == 0) {
                throw new MacroException("Inputs inv\u00e1lidos!");
            }
            try {
                List macro_inputs = this.getInputs();
                if (macro_inputs.size() == inputs.size()) break block4;
                return false;
            }
            catch (MacroException e) {
                return false;
            }
        }
        this.sortedInputs(inputs);
        return true;
    }

    public List getInputs() throws MacroException {
        ArrayList<MakeElement> list = new ArrayList<MakeElement>();
        for (MakeElement me : this.theMakeElements) {
            if (!me.isJokerElement()) continue;
            list.add(me);
        }
        if (list.size() == 0) {
            throw new MacroException("Essa macro n\u00e3o tem inputs!");
        }
        return list;
    }

    private List sortedInputs(List _inputs) throws MacroException {
        if (_inputs == null) {
            throw new MacroException("Os inputs n\u00e3o foram inicializados!");
        }
        ArrayList temp_input_list = new ArrayList();
        temp_input_list.addAll(_inputs);
        ArrayList<MakeElement> sorted_input_list = new ArrayList<MakeElement>();
        List macro_input_list = this.getInputs();
        for (MakeElement object : macro_input_list) {
            boolean match = false;
            MakeElement me2 = null;
            for (MakeElement me2 : temp_input_list) {
                if (!me2.getState().getClass().equals(object.getState().getClass())) continue;
                match = true;
                break;
            }
            if (match) {
                sorted_input_list.add(me2);
                temp_input_list.remove(me2);
                continue;
            }
            throw new MacroException("Os inputs n\u00e3o s\u00e3o v\u00e1lidos!");
        }
        return sorted_input_list;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection getElements() {
        return this.theMakeElements;
    }

    public MenuComponentBase getMenuComponentBase() {
        MenuComponentBase menu = new MenuComponentBase("", 0, "");
        menu.setText(this.name);
        menu.setVisible(true);
        menu.setIdentification(this.code);
        menu.addActionListener((ActionListener)MacroInspector.getInstance());
        return menu;
    }

    public boolean equals(Object o) {
        return o instanceof Macro && this.code == ((Macro)o).code;
    }

    public String toString() {
        return this.getName();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

