/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.macro;

import br.ufrj.labma.enibam.creation.CreationManager;
import br.ufrj.labma.enibam.graphic.GraphicObject;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.gui.MenuComponentBase;
import br.ufrj.labma.enibam.gui.MenuComponentInterface;
import br.ufrj.labma.enibam.gui.window.DataHideDialog;
import br.ufrj.labma.enibam.gui.window.WindowManager;
import br.ufrj.labma.enibam.history.ConversionEngine;
import br.ufrj.labma.enibam.history.ae.MakeElement;
import br.ufrj.labma.enibam.kernel.ConstructionIDMap;
import br.ufrj.labma.enibam.kernel.FactoryCreationParameter;
import br.ufrj.labma.enibam.kernel.KernelProxy;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.macro.Macro;
import br.ufrj.labma.enibam.macro.MacroException;
import br.ufrj.labma.enibam.tm.TransactionManager;
import br.ufrj.labma.enibam.util.TextUtil;
import br.xdev.framework.logging.Logger;
import br.xdev.framework.util.SortedList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

public class MacroInspector
implements ActionListener {
    public static final Integer OID = new Integer(1);
    public static final Integer FCP = new Integer(2);
    private static final String FILE_PATH = "macros.conf";
    private static final int DEFAULT_MAX = 10;
    private static final int MAX_CHAR_LINE_MACRO = 40;
    private static MacroInspector theInstance;
    private static TransactionManager TM;
    private List macroList;
    private static int sequence;
    private MenuComponentBase[] menus = new MenuComponentBase[10];
    private JEditorPane macroDetail;

    static {
        sequence = 0;
    }

    private MacroInspector() {
        this.macroList = new ArrayList();
        this.initialize();
        this.read();
    }

    public static MacroInspector getInstance() {
        if (theInstance == null) {
            theInstance = new MacroInspector();
        }
        return theInstance;
    }

    public static final int getSequence() {
        return sequence++;
    }

    public Collection getMacros() {
        return this.macroList;
    }

    public boolean validate(KernelProxy kernel, Enumeration _inputs, Enumeration _outputs) {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        ArrayList<Integer> path = new ArrayList<Integer>();
        ArrayList<Integer> inputs = new ArrayList<Integer>();
        while (_inputs.hasMoreElements()) {
            inputs.add(((DataHideDialog)_inputs.nextElement()).getGraphicObject().getID());
        }
        ArrayList<Integer> outputs = new ArrayList<Integer>();
        while (_outputs.hasMoreElements()) {
            outputs.add(((DataHideDialog)_outputs.nextElement()).getGraphicObject().getID());
        }
        int i = 0;
        while (i < outputs.size()) {
            List parents = kernel.getImediateParents((Integer)outputs.get(i));
            if (parents == null || parents.size() == 0) {
                return false;
            }
            int j = 0;
            while (j < parents.size()) {
                Integer id = (Integer)parents.get(j);
                if (!temp.contains(id)) {
                    temp.add(id);
                }
                ++j;
            }
            ++i;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (temp.size() > 0) {
            Integer id = (Integer)temp.remove(0);
            if (inputs.contains(id)) {
                if (list.contains(id)) continue;
                list.add(id);
                continue;
            }
            path.add(id);
            List parents = kernel.getImediateParents(id);
            if (parents == null || parents.size() == 0) {
                if (list.contains(id)) continue;
                return false;
            }
            int j = 0;
            while (j < parents.size()) {
                Integer parent = (Integer)parents.get(j);
                if (!temp.contains(parent) && !path.contains(parent)) {
                    temp.add(parent);
                }
                ++j;
            }
        }
        return list.size() == inputs.size() && list.containsAll(inputs);
    }

    public Macro create(KernelProxy kernel, Enumeration _inputs, Enumeration _outputs) throws MacroException {
        TreeSet path = new TreeSet();
        ArrayList<Integer> inputs = new ArrayList<Integer>();
        while (_inputs.hasMoreElements()) {
            inputs.add(((DataHideDialog)_inputs.nextElement()).getGraphicObject().getID());
        }
        ArrayList<Integer> outputs = new ArrayList<Integer>();
        while (_outputs.hasMoreElements()) {
            outputs.add(((DataHideDialog)_outputs.nextElement()).getGraphicObject().getID());
        }
        int[] ids = new int[outputs.size()];
        int i = 0;
        while (i < ids.length) {
            ids[i] = (Integer)outputs.get(i);
            ++i;
        }
        Map FCPs = MacroInspector.getInstance().restoreGraphusOrderByCreation(kernel, ids);
        if (FCPs == null || FCPs.isEmpty()) {
            throw new MacroException("Ouputs sem pais. Macro n\u00e3o pode ser criada!");
        }
        List oids = (List)FCPs.get(OID);
        int i2 = 0;
        while (i2 < inputs.size()) {
            if (!oids.contains(inputs.get(i2))) {
                throw new MacroException("Input n\u00e3o est\u00e1 presente no path para cria\u00e7\u00e3o dos outputs!");
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < oids.size()) {
            path.add(oids.get(i2));
            ++i2;
        }
        SortedList idsToRemove = new SortedList();
        int i3 = 0;
        while (i3 < inputs.size()) {
            Integer ID = (Integer)inputs.get(i3);
            this.getParents(kernel, ID, idsToRemove);
            ++i3;
        }
        idsToRemove.removeAll(inputs);
        path.removeAll((Collection<?>)idsToRemove);
        return this.create(kernel, inputs, path, outputs);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MenuComponentInterface menu = (MenuComponentInterface)e.getSource();
        Macro macro2 = null;
        for (Macro macro2 : this.macroList) {
            if (macro2.getCode() == menu.getIdentification()) break;
            macro2 = null;
        }
        if (macro2 != null) {
            try {
                if (TM != null) {
                    ArrayList<MakeElement> inputs = new ArrayList<MakeElement>();
                    int i = 0;
                    while (i < TM.getViewport().HowManySelected()) {
                        Integer ID = TM.getViewport().getSelected(i);
                        MakeElement me = new MakeElement((State)TM.getProxy().getState(ID).clone(), TM.getProxy().getConstructionID(ID));
                        me.setParents(TM.getProxy().getImediateParents(ID));
                        me.setJokerElement(false);
                        inputs.add(me);
                        ++i;
                    }
                    if (!macro2.validateInputs(inputs)) {
                        WindowManager.getInstance().showAlertDialog((Object)"Inputs inv\u00e1lidos para esta macro!", (Component)((Object)TM.getViewport()));
                    } else {
                        CreationManager cm = new CreationManager();
                        macro2.setInputList(inputs);
                        List elements = macro2.generateMakeElements();
                        Logger.debug((Object)("\nELEMENTS:\n" + elements));
                        boolean result = this.buildObjects(elements, cm);
                        TM.disturb(0, 0);
                        if (!result) {
                            WindowManager.getInstance().showAlertDialog((Object)"Os inputs n\u00e3o s\u00e3o v\u00e1lidos!", (Component)((Object)TM.getViewport()));
                        } else {
                            Logger.debug((Object)"\n macro executed.\n");
                        }
                    }
                } else {
                    Logger.debug((Object)"\nTM is null.\n");
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                WindowManager.getInstance().showAlertDialog((Object)ex.getMessage(), (Component)((Object)TM.getViewport()));
            }
            Logger.debug((Object)("\n\nMACRO:\n" + macro2.toString()));
        } else {
            WindowManager.getInstance().showAlertDialog((Object)"Macro n\u00e3o carregada corretamente.", (Component)((Object)TM.getViewport()));
        }
    }

    public static final int identifyOrder(int id, KernelProxy kernel) {
        int[] mids = kernel.getSiblings(id);
        int order = 0;
        if (mids != null && mids.length > 0) {
            int i = 0;
            while (i < mids.length) {
                if (mids[i] == id) {
                    return order;
                }
                ++order;
                ++i;
            }
        }
        return order;
    }

    private Macro create(KernelProxy kernel, List input, SortedSet path, List output) throws MacroException {
        ArrayList<MakeElement> elements = new ArrayList<MakeElement>();
        for (Integer id : path) {
            MakeElement me = new MakeElement((State)kernel.getState(id).clone(), kernel.getConstructionID(id));
            FactoryCreationParameter FCP = kernel.getFCP(id);
            me.setParents(FCP.getParentsList());
            me.setParameterList(FCP.getParameters());
            me.setJokerElement(input.contains(id));
            me.setOutput(output.contains(id));
            me.setOrder(MacroInspector.identifyOrder(id, kernel));
            if (TM.getViewport() != null && TM.getViewport().getGraphicObject(id) != null) {
                me.setGraphicState(TM.getViewport().getGraphicObject(id).getGraphicState());
            }
            elements.add(me);
        }
        Macro macro = new Macro(elements);
        macro.setCode(MacroInspector.getSequence());
        macro.setName("Macro " + macro.getCode());
        this.add(macro);
        return macro;
    }

    public void setTM(TransactionManager t) {
        TM = t;
    }

    public boolean writeMacro(Macro macro, ConversionEngine ce) {
        Collection elements = macro.getElements();
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            ce.insert((MakeElement)i.next());
        }
        ce.getFileAttribute().setDescription(macro.getDescription());
        return ce.write();
    }

    private boolean buildObjects(List elements, CreationManager cm) {
        for (MakeElement me : elements) {
            List glist = cm.create(me, TM.getProxy(), TM.getViewport(), true, true);
            if (glist != null) {
                int j = 0;
                while (j < glist.size()) {
                    GraphicObject graphic = (GraphicObject)glist.get(j);
                    if (graphic == null) {
                        return false;
                    }
                    TM.getViewport().insert(graphic);
                    MakeElement ae = new MakeElement((State)me.getState().clone(), me.getActionID());
                    ae.setGraphicState((GraphicState)me.getGraphicState().clone());
                    ae.setParents(me.getParents());
                    ae.setParameterList(me.getParameterList());
                    ae.setObjectID(graphic.getID(), MacroInspector.identifyOrder(graphic.getID(), TM.getProxy()));
                    ae.setScale(TM.getViewport().getZoom());
                    TM.getViewport().getHistory().add(ae);
                    graphic.setVisibleStatus(me.isOutput());
                    ++j;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    public void update() {
        int j = 0;
        while (j < 10) {
            this.menus[j].setVisible(false);
            ++j;
        }
        int i = 0;
        while (i < this.macroList.size() && i < 10) {
            Macro macro = (Macro)this.macroList.get(i);
            this.menus[i].setText(i + 1 + ". " + macro.getName());
            this.menus[i].setVisible(true);
            this.menus[i].setIdentification(macro.getCode());
            ++i;
        }
    }

    public void add(Macro macro) {
        if (!this.macroList.contains(macro)) {
            this.macroList.add(0, macro);
        } else if (this.macroList.remove(macro)) {
            this.macroList.add(0, macro);
        }
        if (macro.getCode() == 0) {
            macro.setCode(MacroInspector.getSequence());
        } else if (macro.getCode() >= sequence) {
            sequence = macro.getCode() + 1;
        }
        this.update();
        Logger.debug((Object)("Macro=" + macro));
    }

    public void remove(Macro macro) {
        this.macroList.remove(macro);
    }

    private void initialize() {
        int i = 0;
        while (i < 10) {
            this.menus[i] = new MenuComponentBase("", i, "");
            this.menus[i].setVisible(false);
            this.menus[i].addActionListener((ActionListener)this);
            ++i;
        }
    }

    public List getMenus() {
        ArrayList<MenuComponentBase> list = new ArrayList<MenuComponentBase>();
        int i = 0;
        while (i < this.menus.length) {
            list.add(this.menus[i]);
            ++i;
        }
        return list;
    }

    private boolean read() {
        try {
            File file = new File(FILE_PATH);
            if (file.exists()) {
                ObjectInputStream DI = new ObjectInputStream(new FileInputStream(file));
                List list = (List)DI.readObject();
                DI.close();
                if (list != null) {
                    int i = list.size() - 1;
                    while (i >= 0) {
                        this.add((Macro)list.get(i));
                        --i;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean write() {
        try {
            File file = new File(FILE_PATH);
            ObjectOutputStream DO = new ObjectOutputStream(new FileOutputStream(file));
            ArrayList list = new ArrayList();
            int i = 0;
            while (i < this.macroList.size() && i < 10) {
                list.add(this.macroList.get(i));
                ++i;
            }
            DO.writeObject(list);
            DO.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public JScrollPane getPanelDescription(Macro macro) {
        if (this.macroDetail == null) {
            this.macroDetail = new JEditorPane();
        }
        this.macroDetail.setContentType("text/html");
        this.macroDetail.setEditable(false);
        this.macroDetail.setMinimumSize(new Dimension(0, 0));
        if (macro.getDescription() == null) {
            macro.setDescription("<sem descri\u00e7\u00e3o>");
        }
        String content = "<table>";
        content = String.valueOf(content) + "<tr><td align=left><b>Macro:</b></td><td align=left>" + macro.getName() + "</td></tr>";
        content = String.valueOf(content) + "<tr><td align=left colspan=2><i>" + TextUtil.formatWordWrap((String)macro.getDescription(), (int)40, (String)"<BR>") + "</i></td></tr>";
        content = String.valueOf(content) + "<tr><td colspan=2>&nbsp;</td></tr>";
        content = String.valueOf(content) + "</table>";
        content = String.valueOf(content) + "<table ><tr><td valign=top><table border=1  style=border-collapse:collapse;font-family:verdana>";
        content = String.valueOf(content) + "<tr valign=middle><td  style=background:#AAAAFF;padding:4px align=center><b>Input</b></td>";
        content = String.valueOf(content) + "</tr><tr align=left valign=middle ><td style=padding:4px;font-family:verdana;font-size:12>";
        int counter = 1;
        for (MakeElement me : macro.getElements()) {
            if (!me.isJokerElement()) continue;
            content = String.valueOf(content) + "(" + counter++ + ") " + ConstructionIDMap.parseString(me.getActionID()) + "<br>";
        }
        content = String.valueOf(content) + "</td></table></td><td valign=middle>";
        content = String.valueOf(content) + "<table ><tr><td></td></tr><tr><td style=padding:4px;font-family:verdana;font-size:12><b>=></b></td></tr></table>";
        content = String.valueOf(content) + "</td><td valign=top>";
        content = String.valueOf(content) + "<table border=1  style=border-collapse:collapse;font-family:verdana>";
        content = String.valueOf(content) + "<tr><td style=background:#AAAAFF;padding:4px align=center><b>Output</b></td></tr>";
        content = String.valueOf(content) + "<tr><td style=padding:4px;font-family:verdana;font-size:12>";
        counter = 1;
        for (MakeElement me : macro.getElements()) {
            if (!me.isOutput()) continue;
            content = String.valueOf(content) + "(" + counter++ + ") " + ConstructionIDMap.parseString(me.getActionID()) + "<br>";
        }
        content = String.valueOf(content) + "</td></tr></table></td></tr></table>";
        this.macroDetail.setText("<HTML>" + content + "</HTML>");
        return new JScrollPane(this.macroDetail);
    }

    public Map restoreGraphusOrderByCreation(KernelProxy kernel, int[] ids) {
        HashMap mapResult = new HashMap();
        ArrayList<FactoryCreationParameter> fcps = new ArrayList<FactoryCreationParameter>();
        ArrayList<Integer> oids = new ArrayList<Integer>();
        SortedList result = new SortedList();
        int i = 0;
        while (i < ids.length) {
            Integer ID = new Integer(ids[i]);
            this.getParents(kernel, ID, result);
            ++i;
        }
        i = result.size() - 1;
        while (i >= 0) {
            fcps.add(kernel.getFCP((Integer)result.get(i)));
            oids.add((Integer)result.get(i));
            --i;
        }
        mapResult.put(OID, oids);
        mapResult.put(FCP, fcps);
        return mapResult;
    }

    private SortedList getParents(KernelProxy kernel, Integer ID, SortedList result) {
        if (ID != null && kernel != null && result != null) {
            List parents;
            if (!result.contains((Object)ID)) {
                result.add((Comparable)ID);
            }
            if ((parents = kernel.getImediateParents(ID)) == null || parents.size() == 0) {
                return result;
            }
            int i = 0;
            while (i < parents.size()) {
                Integer _id = (Integer)parents.get(i);
                if (!result.contains((Object)_id)) {
                    result.add((Comparable)_id);
                    this.getParents(kernel, _id, result);
                }
                ++i;
            }
        }
        return result;
    }
}

