/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.tm;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public class EPSGraphics2D
extends Graphics {
    private Color _currentColor = Color.black;
    private Font _currentFont;
    private int _width;
    private int _height;
    private String _out;
    private StringBuffer _buffer = new StringBuffer();
    private double escalax = 1.0;
    private double escalay = 1.0;
    private double transx = 0.0;
    private double transy = 0.0;
    private boolean dorestore = false;

    public EPSGraphics2D(String name, int width, int height) {
        this._width = width;
        this._height = height;
        this._out = name;
        this._buffer.append("%!PS-Adobe-3.0 EPSF-3.0\n");
        this._buffer.append("%%Creator: JCF\n");
        this._buffer.append("%%BoundingBox: 0 0 700 450\n");
        this._buffer.append("%%Pages: 1\n");
        this._buffer.append("%%Page: 1 1\n");
        this._buffer.append("%%LanguageLevel: 2\n");
    }

    @Override
    public Graphics create() {
        return new EPSGraphics2D(this._out, this._width, this._height);
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
    }

    public void draw(Shape s) {
        if (s instanceof Line2D) {
            this.drawLine((int)((Line2D)s).getX1(), (int)((Line2D)s).getY1(), (int)((Line2D)s).getX2(), (int)((Line2D)s).getY2());
        }
        if (s instanceof Ellipse2D) {
            this.drawOval((int)((Ellipse2D)s).getX(), (int)((Ellipse2D)s).getY(), (int)((Ellipse2D)s).getWidth(), (int)((Ellipse2D)s).getHeight());
        }
        if (s instanceof GeneralPath) {
            GeneralPath pol = (GeneralPath)s;
            PathIterator pi = pol.getPathIterator(null);
            double[] c = new double[6];
            int npoints = 0;
            while (!pi.isDone()) {
                pi.currentSegment(c);
                ++npoints;
                pi.next();
            }
            int[] xs = new int[npoints];
            int[] ys = new int[npoints];
            pol.getPathIterator(null);
            int n = 0;
            while (!pi.isDone()) {
                pi.currentSegment(c);
                xs[n] = (int)c[0];
                ys[0] = (int)c[1];
                ++n;
                pi.next();
            }
            this.drawPolygon(xs, ys, npoints);
        }
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return false;
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
    }

    public void drawString(String s, float x, float y) {
        this.drawString(s, (int)x, (int)y);
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
    }

    public void fill(Shape s) {
        if (s instanceof Ellipse2D) {
            this.fillOval((int)((Ellipse2D)s).getX(), (int)((Ellipse2D)s).getY(), (int)((Ellipse2D)s).getWidth(), (int)((Ellipse2D)s).getHeight());
        }
        if (s instanceof GeneralPath) {
            GeneralPath pol = (GeneralPath)s;
            PathIterator pi = pol.getPathIterator(null);
            double[] c = new double[6];
            int npoints = 0;
            while (!pi.isDone()) {
                pi.currentSegment(c);
                ++npoints;
                pi.next();
            }
            int[] xs = new int[npoints];
            int[] ys = new int[npoints];
            PathIterator pi2 = pol.getPathIterator(null);
            int n = 0;
            while (!pi2.isDone()) {
                pi2.currentSegment(c);
                xs[n] = (int)c[0];
                ys[n] = (int)c[1];
                ++n;
                pi2.next();
            }
            this.fillPolygon(xs, ys, npoints);
        }
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return false;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    public void setComposite(Composite comp) {
    }

    public void setPaint(Paint paint) {
        this.setColor((Color)paint);
    }

    public void setStroke(Stroke s) {
        if (this.dorestore) {
            this._buffer.append("grestore\n");
        }
        this._buffer.append("\n gsave \n");
        this.dorestore = true;
        BasicStroke b = (BasicStroke)s;
        int wd = (int)b.getLineWidth();
        this._buffer.append(" " + String.valueOf(wd) + " setlinewidth\n");
        float[] ba = b.getDashArray();
        if (ba != null) {
            this._buffer.append("[" + String.valueOf(ba[0]) + " " + String.valueOf(ba[1]) + "] " + String.valueOf((int)b.getDashPhase()) + " setdash\n");
        }
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return null;
    }

    public void setRenderingHints(Map hints) {
    }

    public void addRenderingHints(Map hints) {
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    @Override
    public void translate(int x, int y) {
        this.transx = x;
        this.transy = y;
    }

    public void translate(double tx, double ty) {
        this.transx = tx;
        this.transy = ty;
    }

    public void rotate(double theta) {
    }

    public void rotate(double theta, double x, double y) {
    }

    public void scale(double sx, double sy) {
        this.escalax = sx;
        this.escalay = sy;
    }

    public void shear(double shx, double shy) {
    }

    public void transform(AffineTransform Tx) {
    }

    public void setTransform(AffineTransform Tx) {
    }

    public AffineTransform getTransform() {
        return null;
    }

    public Paint getPaint() {
        return null;
    }

    public Composite getComposite() {
        return null;
    }

    public void setBackground(Color color) {
    }

    public Color getBackground() {
        return Color.white;
    }

    public Stroke getStroke() {
        return null;
    }

    public void clip(Shape s) {
    }

    public FontRenderContext getFontRenderContext() {
        return null;
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return true;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        Point start = this._convert(x1, y1);
        Point end = this._convert(x2, y2);
        this._buffer.append("newpath " + start.x + " " + start.y + " moveto\n");
        this._buffer.append(end.x + " " + end.y + " lineto\n");
        this._buffer.append("stroke\n");
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (!this._polygon(xPoints, yPoints, nPoints)) {
            return;
        }
        this._buffer.append("closepath stroke\n");
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        int radius = width / 2;
        Point center = this._convert(x + radius, y + radius);
        this._buffer.append("newpath " + center.x + " " + center.y + " " + radius + " 0 360 arc closepath stroke\n");
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        Point start = this._convert(x, y);
        this._buffer.append("newpath " + start.x + " " + start.y + " moveto\n");
        this._buffer.append("0 " + -height + " rlineto\n");
        this._buffer.append(width + " 0 rlineto\n");
        this._buffer.append("0 " + height + " rlineto\n");
        this._buffer.append(-width + " 0 rlineto\n");
        this._buffer.append("closepath stroke\n");
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        throw new RuntimeException("Sorry, drawString(java.text.AttributedCharacterIterator, int , int) is not implemented in EPSGraphics");
    }

    @Override
    public void drawString(String str, int x, int y) {
        Point start = this._convert(x, y);
        this._buffer.append(start.x + " " + start.y + " moveto\n");
        this._buffer.append("(" + str + ") show\n");
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this._buffer.append("gsave\n");
        if (!this._polygon(xPoints, yPoints, nPoints)) {
            return;
        }
        this._buffer.append("eofill newpath\n");
        this._buffer.append("grestore\n");
        this._polygon(xPoints, yPoints, nPoints);
        this._buffer.append("closepath stroke newpath\n");
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        int radius = width / 2;
        Point center = this._convert(x + radius, y + radius);
        this._buffer.append("newpath " + center.x + " " + center.y + " " + radius + " 0 360 arc closepath fill\n");
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        Point start = this._convert(x, y);
        this._fillPattern();
        this._buffer.append("newpath " + start.x + " " + start.y + " moveto\n");
        this._buffer.append("0 " + -height + " rlineto\n");
        this._buffer.append(width + " 0 rlineto\n");
        this._buffer.append("0 " + height + " rlineto\n");
        this._buffer.append(-width + " 0 rlineto\n");
        this._buffer.append("closepath gsave fill grestore\n");
        this._buffer.append("0.5 setlinewidth 0 setgray [] 0 setdash stroke\n");
        this._buffer.append("1 setlinewidth\n");
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    @Override
    public Shape getClip() {
        return null;
    }

    @Override
    public Rectangle getClipBounds() {
        return null;
    }

    @Override
    public Color getColor() {
        return this._currentColor;
    }

    @Override
    public Font getFont() {
        return this._currentFont;
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return null;
    }

    @Override
    public void setFont(Font font) {
        int size = font.getSize();
        boolean bold = font.isBold();
        if (bold) {
            this._buffer.append("/Helvetica-Bold findfont\n");
        } else {
            this._buffer.append("/Helvetica findfont\n");
        }
        this._buffer.append(size + " scalefont setfont\n");
        this._currentFont = font;
    }

    @Override
    public void setClip(Shape clip) {
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
    }

    @Override
    public void setColor(Color c) {
        this._buffer.append((double)c.getRed() / 255.0);
        this._buffer.append(" ");
        this._buffer.append((double)c.getGreen() / 255.0);
        this._buffer.append(" ");
        this._buffer.append((double)c.getBlue() / 255.0);
        this._buffer.append(" setrgbcolor\n");
        this._currentColor = c;
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color c1) {
    }

    public void showpage() {
        try {
            this._buffer.append("grestore\n");
            this._buffer.append("%%EOF");
            PrintWriter output = new PrintWriter(new FileWriter(this._out));
            output.println(this._buffer.toString());
            output.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Point _convert(int x, int y) {
        return new Point((int)((double)(x + 50) * this.escalax + this.transx), (int)((double)(this._height + 50 - y) * this.escalay + this.transy));
    }

    private boolean _polygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (nPoints < 3 || xPoints.length < nPoints || yPoints.length < nPoints) {
            return false;
        }
        Point start = this._convert(xPoints[0], yPoints[0]);
        this._buffer.append("newpath " + start.x + " " + start.y + " moveto\n");
        int i = 1;
        while (i < nPoints) {
            Point vertex = this._convert(xPoints[i], yPoints[i]);
            this._buffer.append(vertex.x + " " + vertex.y + " lineto\n");
            ++i;
        }
        return true;
    }

    private void _fillPattern() {
        int red = this._currentColor.getRed();
        int green = this._currentColor.getGreen();
        int blue = this._currentColor.getBlue();
        double bluescale = 0.6;
        double redscale = 0.8;
        double greenscale = 1.0;
        double fullscale = Math.sqrt(65025.0 * (bluescale * bluescale + redscale * redscale + greenscale * greenscale));
        double graylevel = Math.sqrt((double)(red * red) * redscale * redscale + (double)(blue * blue) * bluescale * bluescale + (double)(green * green) * greenscale * greenscale) / fullscale;
        this._buffer.append(graylevel + " setgray\n");
        this._buffer.append("%---- rgb: " + red + " " + green + " " + blue + "\n");
    }
}

