/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.tm.manager;

import br.ufrj.labma.enibam.creation.CreationManager;
import br.ufrj.labma.enibam.graphic.GraphicState;
import br.ufrj.labma.enibam.kernel.state.AngleState;
import br.ufrj.labma.enibam.kernel.state.ArcInteriorSectorState;
import br.ufrj.labma.enibam.kernel.state.ArcInteriorSegmentState;
import br.ufrj.labma.enibam.kernel.state.ArcState;
import br.ufrj.labma.enibam.kernel.state.AreaState;
import br.ufrj.labma.enibam.kernel.state.AxesState;
import br.ufrj.labma.enibam.kernel.state.CircleInteriorState;
import br.ufrj.labma.enibam.kernel.state.CircleState;
import br.ufrj.labma.enibam.kernel.state.CircularSectorState;
import br.ufrj.labma.enibam.kernel.state.CircularSegmentState;
import br.ufrj.labma.enibam.kernel.state.ConicState;
import br.ufrj.labma.enibam.kernel.state.DotProductState;
import br.ufrj.labma.enibam.kernel.state.FunctionState;
import br.ufrj.labma.enibam.kernel.state.GenericLineState;
import br.ufrj.labma.enibam.kernel.state.LengthState;
import br.ufrj.labma.enibam.kernel.state.LocusState;
import br.ufrj.labma.enibam.kernel.state.PointState;
import br.ufrj.labma.enibam.kernel.state.PolygonState;
import br.ufrj.labma.enibam.kernel.state.RatioState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.kernel.state.TextState;
import br.ufrj.labma.enibam.kernel.state.TriangleState;
import br.ufrj.labma.enibam.kernel.state.UnitaryMeasureState;
import br.ufrj.labma.enibam.kernel.state.VectorState;
import br.ufrj.labma.enibam.tm.manager.StateManagerException;
import br.ufrj.labma.enibam.util.GraphicUtilities;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;

public class StateManager {
    private static StateManager theInstance;
    private static final GraphicState defaultConfiguration;

    static {
        defaultConfiguration = new GraphicState("");
    }

    private StateManager() {
    }

    public static StateManager getInstance() {
        if (theInstance == null) {
            theInstance = new StateManager();
        }
        return theInstance;
    }

    public GraphicState createGraphicState(int CID, Map map) throws StateManagerException {
        GraphicState GS = new GraphicState("");
        try {
            int fontSize;
            int fontStyle;
            String font = (String)map.get("font".toUpperCase());
            if (font == null) {
                font = StateManager.defaultConfiguration.itsFont.getName();
            }
            try {
                fontStyle = Integer.parseInt((String)map.get("fontStyle".toUpperCase()));
            }
            catch (NumberFormatException e) {
                fontStyle = StateManager.defaultConfiguration.itsFont.getStyle();
            }
            try {
                fontSize = Integer.parseInt((String)map.get("fontSize".toUpperCase()));
            }
            catch (NumberFormatException e) {
                fontSize = StateManager.defaultConfiguration.itsFont.getSize();
            }
            GS.itsFont = new Font(font, fontStyle, fontSize);
            String visible_status = (String)map.get("visible".toUpperCase());
            GS.itsVisibleStatus = visible_status != null ? new Boolean(visible_status) : true;
            String str = (String)map.get("labelname".toUpperCase());
            GS.itsLabel = str != null ? str : StateManager.defaultConfiguration.itsLabel;
            str = (String)map.get("reference".toUpperCase());
            GS.itsReferenceName = str != null ? str : StateManager.defaultConfiguration.itsReferenceName;
            str = (String)map.get("description".toUpperCase());
            GS.itsDescription = str != null ? str : StateManager.defaultConfiguration.itsDescription;
            GS.itsLabelStatus = new Boolean((String)map.get("label_visible".toUpperCase()));
            GS.itsDotStatus = new Boolean((String)map.get("dot".toUpperCase()));
            String colorSelected = (String)map.get("colorSelected".toUpperCase());
            GS.colorWhenSelected = colorSelected != null ? GraphicUtilities.HexaToColor(colorSelected) : StateManager.defaultConfiguration.colorWhenSelected;
            String color = (String)map.get("color".toUpperCase());
            GS.myColor = color != null ? GraphicUtilities.HexaToColor(color) : StateManager.defaultConfiguration.myColor;
            String labelColor = (String)map.get("labelColor".toUpperCase());
            GS.labelColor = labelColor != null ? GraphicUtilities.HexaToColor(labelColor) : StateManager.defaultConfiguration.labelColor;
            try {
                GS.thickness = Integer.parseInt((String)map.get("thickness".toUpperCase()));
            }
            catch (NumberFormatException e) {
                GS.thickness = StateManager.defaultConfiguration.thickness;
            }
            try {
                GS.itsX = Integer.parseInt((String)map.get("devX".toUpperCase()));
            }
            catch (NumberFormatException e) {
                GS.itsX = StateManager.defaultConfiguration.itsX;
            }
            try {
                GS.itsY = Integer.parseInt((String)map.get("devY".toUpperCase()));
            }
            catch (NumberFormatException e) {
                GS.itsY = StateManager.defaultConfiguration.itsY;
            }
            try {
                GS.itsXLabel = Integer.parseInt((String)map.get("lbX".toUpperCase()));
            }
            catch (NumberFormatException e) {
                GS.itsXLabel = StateManager.defaultConfiguration.itsXLabel;
            }
            try {
                GS.itsYLabel = Integer.parseInt((String)map.get("lbY".toUpperCase()));
            }
            catch (NumberFormatException e) {
                GS.itsYLabel = StateManager.defaultConfiguration.itsYLabel;
            }
            return GS;
        }
        catch (Exception e) {
            System.out.println("createGraphicState  - 129");
            throw new StateManagerException("N\u00e3o \u00e9 poss\u00edvel criar um GraphicState para esse objeto.");
        }
    }

    public State createState(int CID, Map map) throws StateManagerException {
        int ID = CreationManager.getGraphicID(CID);
        try {
            if (ID == 5000) {
                PointState PS = new PointState();
                try {
                    PS.itsX = (Double)map.get("x".toUpperCase());
                }
                catch (NullPointerException e) {
                    PS.itsX = 0.0;
                }
                try {
                    PS.itsY = (Double)map.get("y".toUpperCase());
                }
                catch (NullPointerException e) {
                    PS.itsY = 0.0;
                }
                return PS;
            }
            if (ID == 5010 || ID == 5005 || ID == 5015) {
                GenericLineState GL = new GenericLineState();
                try {
                    GL.itsX1 = (Double)map.get("x1".toUpperCase());
                }
                catch (NullPointerException e) {
                    GL.itsX1 = 0.0;
                }
                try {
                    GL.itsY1 = (Double)map.get("y1".toUpperCase());
                }
                catch (NullPointerException e) {
                    GL.itsY1 = 0.0;
                }
                try {
                    GL.itsX2 = (Double)map.get("x2".toUpperCase());
                }
                catch (NullPointerException e) {
                    GL.itsX2 = 0.0;
                }
                try {
                    GL.itsY2 = (Double)map.get("y2".toUpperCase());
                }
                catch (NullPointerException e) {
                    GL.itsY2 = 0.0;
                }
                return GL;
            }
            if (ID == 5020) {
                CircleState CS = new CircleState();
                try {
                    CS.itsCenterX = (Double)map.get("centerX".toUpperCase());
                }
                catch (NullPointerException e) {
                    CS.itsCenterX = 0.0;
                }
                try {
                    CS.itsCenterY = (Double)map.get("centerY".toUpperCase());
                }
                catch (NullPointerException e) {
                    CS.itsCenterY = 0.0;
                }
                try {
                    CS.itsRadius = (Double)map.get("radius".toUpperCase());
                }
                catch (NullPointerException e) {
                    CS.itsRadius = 0.0;
                }
                return CS;
            }
            if (ID == 5021) {
                CircleInteriorState CIS = new CircleInteriorState();
                try {
                    CIS.itsCenterX = (Double)map.get("centerX".toUpperCase());
                }
                catch (NullPointerException e) {
                    CIS.itsCenterX = 0.0;
                }
                try {
                    CIS.itsCenterY = (Double)map.get("centerY".toUpperCase());
                }
                catch (NullPointerException e) {
                    CIS.itsCenterY = 0.0;
                }
                try {
                    CIS.itsRadius = (Double)map.get("radius".toUpperCase());
                }
                catch (NullPointerException e) {
                    CIS.itsRadius = 0.0;
                }
                return CIS;
            }
            if (ID == 5040) {
                return new LocusState();
            }
            if (ID == 5025 || ID == 5034) {
                RatioState RS = new RatioState();
                try {
                    RS.itsRatio = (Double)map.get("ratio".toUpperCase());
                }
                catch (NullPointerException e) {
                    RS.itsRatio = 0.0;
                }
                try {
                    RS.itsRatioDimension = (int)((Double)map.get("rdim".toUpperCase())).doubleValue();
                }
                catch (NullPointerException e) {
                    RS.itsRatioDimension = 0;
                }
                return RS;
            }
            if (ID == 5030) {
                AngleState AS = new AngleState();
                try {
                    AS.itsAngle = (Double)map.get("angle".toUpperCase());
                }
                catch (NullPointerException e) {
                    AS.itsAngle = 0.0;
                }
                return AS;
            }
            if (ID == 5031) {
                LengthState LS = new LengthState();
                try {
                    LS.itsLength = (Double)map.get("length".toUpperCase());
                }
                catch (NullPointerException e) {
                    LS.itsLength = 0.0;
                }
                return LS;
            }
            if (ID == 5032) {
                AreaState AA = new AreaState();
                try {
                    AA.itsArea = (Double)map.get("area".toUpperCase());
                }
                catch (NullPointerException e) {
                    AA.itsArea = 0.0;
                }
                return AA;
            }
            if (ID == 5033) {
                FunctionState FS = new FunctionState();
                try {
                    FS.itsValue = (Double)map.get("func".toUpperCase());
                }
                catch (NullPointerException e) {
                    FS.itsValue = 0.0;
                }
                return FS;
            }
            if (ID == 5035) {
                VectorState VS = new VectorState();
                try {
                    VS.itsX1 = (Double)map.get("x1".toUpperCase());
                }
                catch (NullPointerException e) {
                    VS.itsX1 = 0.0;
                }
                try {
                    VS.itsY1 = (Double)map.get("y1".toUpperCase());
                }
                catch (NullPointerException e) {
                    VS.itsY1 = 0.0;
                }
                try {
                    VS.itsX2 = (Double)map.get("x2".toUpperCase());
                }
                catch (NullPointerException e) {
                    VS.itsX2 = 0.0;
                }
                try {
                    VS.itsY2 = (Double)map.get("y2".toUpperCase());
                }
                catch (NullPointerException e) {
                    VS.itsY2 = 0.0;
                }
                return VS;
            }
            if (ID == 5050) {
                return new ConicState();
            }
            if (ID == 5070) {
                return new PolygonState();
            }
            if (ID == 5060) {
                TriangleState TS = new TriangleState();
                try {
                    TS.itsX1 = (Double)map.get("x1".toUpperCase());
                }
                catch (NullPointerException e) {
                    TS.itsX1 = 0.0;
                }
                try {
                    TS.itsY1 = (Double)map.get("y1".toUpperCase());
                }
                catch (NullPointerException e) {
                    TS.itsY1 = 0.0;
                }
                try {
                    TS.itsX2 = (Double)map.get("x2".toUpperCase());
                }
                catch (NullPointerException e) {
                    TS.itsX2 = 0.0;
                }
                try {
                    TS.itsY2 = (Double)map.get("y2".toUpperCase());
                }
                catch (NullPointerException e) {
                    TS.itsY2 = 0.0;
                }
                try {
                    TS.itsX3 = (Double)map.get("x3".toUpperCase());
                }
                catch (NullPointerException e) {
                    TS.itsX3 = 0.0;
                }
                try {
                    TS.itsY3 = (Double)map.get("y3".toUpperCase());
                }
                catch (NullPointerException e) {
                    TS.itsY3 = 0.0;
                }
                return TS;
            }
            if (ID == 5080) {
                DotProductState DPS = new DotProductState();
                try {
                    DPS.itsDotProduct = (Double)map.get("product".toUpperCase());
                }
                catch (NullPointerException e) {
                    DPS.itsDotProduct = 0.0;
                }
                return DPS;
            }
            if (ID == 5090) {
                return new LocusState();
            }
            if (ID == 5095) {
                return new LocusState();
            }
            if (ID == 5097) {
                return new LocusState();
            }
            if (ID == 5099) {
                return new LocusState();
            }
            if (ID == 5085) {
                ArcState AS = new ArcState();
                try {
                    AS.itsArcAngle = (Double)map.get("arc".toUpperCase());
                }
                catch (NullPointerException e) {
                    AS.itsArcAngle = 0.0;
                }
                try {
                    AS.itsStartingAngle = (Double)map.get("startingAngle".toUpperCase());
                }
                catch (NullPointerException e) {
                    AS.itsStartingAngle = 0.0;
                }
                try {
                    AS.itsCenterX = (Double)map.get("centerX".toUpperCase());
                }
                catch (NullPointerException e) {
                    AS.itsCenterX = 0.0;
                }
                try {
                    AS.itsCenterY = (Double)map.get("centerY".toUpperCase());
                }
                catch (NullPointerException e) {
                    AS.itsCenterY = 0.0;
                }
                try {
                    AS.itsRadius = (Double)map.get("radius".toUpperCase());
                }
                catch (NullPointerException e) {
                    AS.itsRadius = 0.0;
                }
                return AS;
            }
            if (ID == 5200) {
                AxesState AS = new AxesState();
                try {
                    AS.itsX1 = (Double)map.get("x1".toUpperCase());
                }
                catch (NullPointerException e) {
                    AS.itsX1 = 0.0;
                }
                try {
                    AS.itsY1 = (Double)map.get("y1".toUpperCase());
                }
                catch (NullPointerException e) {
                    AS.itsY1 = 0.0;
                }
                try {
                    AS.itsX2 = (Double)map.get("x2".toUpperCase());
                }
                catch (NullPointerException e) {
                    AS.itsX2 = 0.0;
                }
                try {
                    AS.itsY2 = (Double)map.get("y2".toUpperCase());
                }
                catch (NullPointerException e) {
                    AS.itsY2 = 0.0;
                }
                try {
                    AS.itsOriginX = (Double)map.get("x3".toUpperCase());
                }
                catch (NullPointerException e) {
                    AS.itsOriginX = 0.0;
                }
                try {
                    AS.itsOriginY = (Double)map.get("y3".toUpperCase());
                }
                catch (NullPointerException e) {
                    AS.itsOriginY = 0.0;
                }
                return AS;
            }
            if (ID == 5023) {
                ArcInteriorSegmentState AISS = new ArcInteriorSegmentState();
                try {
                    AISS.itsAngle = (Double)map.get("arc".toUpperCase());
                }
                catch (NullPointerException e) {
                    AISS.itsAngle = 0.0;
                }
                try {
                    AISS.itsStartingAngle = (Double)map.get("startingAngle".toUpperCase());
                }
                catch (NullPointerException e) {
                    AISS.itsStartingAngle = 0.0;
                }
                try {
                    AISS.itsCenterX = (Double)map.get("centerX".toUpperCase());
                }
                catch (NullPointerException e) {
                    AISS.itsCenterX = 0.0;
                }
                try {
                    AISS.itsCenterY = (Double)map.get("centerY".toUpperCase());
                }
                catch (NullPointerException e) {
                    AISS.itsCenterY = 0.0;
                }
                try {
                    AISS.itsRadius = (Double)map.get("radius".toUpperCase());
                }
                catch (NullPointerException e) {
                    AISS.itsRadius = 0.0;
                }
                return AISS;
            }
            if (ID == 5022) {
                ArcInteriorSectorState AIS = new ArcInteriorSectorState();
                try {
                    AIS.itsAngle = (Double)map.get("arc".toUpperCase());
                }
                catch (NullPointerException e) {
                    AIS.itsAngle = 0.0;
                }
                try {
                    AIS.itsStartingAngle = (Double)map.get("startingAngle".toUpperCase());
                }
                catch (NullPointerException e) {
                    AIS.itsStartingAngle = 0.0;
                }
                try {
                    AIS.itsCenterX = (Double)map.get("centerX".toUpperCase());
                }
                catch (NullPointerException e) {
                    AIS.itsCenterX = 0.0;
                }
                try {
                    AIS.itsCenterY = (Double)map.get("centerY".toUpperCase());
                }
                catch (NullPointerException e) {
                    AIS.itsCenterY = 0.0;
                }
                try {
                    AIS.itsRadius = (Double)map.get("radius".toUpperCase());
                }
                catch (NullPointerException e) {
                    AIS.itsRadius = 0.0;
                }
                return AIS;
            }
            if (ID == 5086) {
                CircularSectorState CSS = new CircularSectorState();
                try {
                    CSS.itsCenterX = (Double)map.get("centerX".toUpperCase());
                }
                catch (NullPointerException e) {
                    CSS.itsCenterX = 0.0;
                }
                try {
                    CSS.itsCenterY = (Double)map.get("centerY".toUpperCase());
                }
                catch (NullPointerException e) {
                    CSS.itsCenterY = 0.0;
                }
                try {
                    CSS.itsRadius = (Double)map.get("radius".toUpperCase());
                }
                catch (NullPointerException e) {
                    CSS.itsRadius = 0.0;
                }
                try {
                    CSS.itsAngle = (Double)map.get("angle".toUpperCase());
                }
                catch (NullPointerException e) {
                    CSS.itsAngle = 0.0;
                }
                try {
                    CSS.itsStartingAngle = (Double)map.get("startingAngle".toUpperCase());
                }
                catch (NullPointerException e) {
                    CSS.itsStartingAngle = 0.0;
                }
                return CSS;
            }
            if (ID == 5087) {
                CircularSegmentState CSS = new CircularSegmentState();
                try {
                    CSS.itsCenterX = (Double)map.get("centerX".toUpperCase());
                }
                catch (NullPointerException e) {
                    CSS.itsCenterX = 0.0;
                }
                try {
                    CSS.itsCenterY = (Double)map.get("centerY".toUpperCase());
                }
                catch (NullPointerException e) {
                    CSS.itsCenterY = 0.0;
                }
                try {
                    CSS.itsRadius = (Double)map.get("radius".toUpperCase());
                }
                catch (NullPointerException e) {
                    CSS.itsRadius = 0.0;
                }
                try {
                    CSS.itsAngle = (Double)map.get("angle".toUpperCase());
                }
                catch (NullPointerException e) {
                    CSS.itsAngle = 0.0;
                }
                try {
                    CSS.itsStartingAngle = (Double)map.get("startingAngle".toUpperCase());
                }
                catch (NullPointerException e) {
                    CSS.itsStartingAngle = 0.0;
                }
                return CSS;
            }
            if (ID == 9050) {
                TextState TS = new TextState();
                TS.itsText = (String)map.get("texto".toUpperCase());
                return TS;
            }
            if (ID == 5110) {
                UnitaryMeasureState UM = new UnitaryMeasureState();
                UM.itsUnitaryMeasureConstant = (Double)map.get("unidade".toUpperCase());
                return UM;
            }
            System.out.println("create State  - 279");
            throw new StateManagerException("N\u00e3o \u00e9 poss\u00edvel criar um State para esse objeto.");
        }
        catch (Exception e) {
            System.out.println("create State   - 283");
            throw new StateManagerException("N\u00e3o \u00e9 poss\u00edvel criar um State para esse objeto.");
        }
    }

    public Map createMap(int CID, GraphicState gs) throws StateManagerException {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            if (gs == null) {
                return map;
            }
            if (!StateManager.defaultConfiguration.itsFont.getName().equals(gs.itsFont.getName()) || StateManager.defaultConfiguration.itsFont.getStyle() != gs.itsFont.getStyle() || StateManager.defaultConfiguration.itsFont.getSize() != gs.itsFont.getSize()) {
                map.put("font", gs.itsFont.getName());
                map.put("fontStyle", "" + gs.itsFont.getStyle());
                map.put("fontSize", "" + gs.itsFont.getSize());
            }
            if (!gs.itsVisibleStatus) {
                map.put("visible", "" + gs.itsVisibleStatus);
            }
            if (gs.itsLabelStatus) {
                map.put("label_visible", "" + gs.itsLabelStatus);
            }
            if (gs.itsLabel != null && !gs.itsLabel.equals("")) {
                map.put("labelname", gs.itsLabel);
            }
            if (gs.itsReferenceName != null && !gs.itsReferenceName.equals("")) {
                map.put("reference", gs.itsReferenceName);
            }
            if (gs.itsDescription != null && !gs.itsDescription.equals(StateManager.defaultConfiguration.itsDescription)) {
                map.put("description", gs.itsDescription);
            }
            if (gs.itsDotStatus) {
                map.put("dot", "" + gs.itsDotStatus);
            }
            if (!StateManager.defaultConfiguration.colorWhenSelected.equals(gs.colorWhenSelected)) {
                map.put("colorSelected", GraphicUtilities.ColorToHexa(gs.colorWhenSelected));
            }
            if (!StateManager.defaultConfiguration.myColor.equals(gs.myColor)) {
                map.put("color", GraphicUtilities.ColorToHexa(gs.myColor));
            }
            if (!StateManager.defaultConfiguration.labelColor.equals(gs.labelColor)) {
                map.put("labelColor", GraphicUtilities.ColorToHexa(gs.labelColor));
            }
            if (StateManager.defaultConfiguration.thickness != gs.thickness) {
                map.put("thickness", "" + gs.thickness);
            }
            if (StateManager.defaultConfiguration.itsX != gs.itsX) {
                map.put("devX", "" + gs.itsX);
            }
            if (StateManager.defaultConfiguration.itsY != gs.itsY) {
                map.put("devY", "" + gs.itsY);
            }
            if (StateManager.defaultConfiguration.itsXLabel != gs.itsXLabel) {
                map.put("lbX", "" + gs.itsXLabel);
            }
            if (StateManager.defaultConfiguration.itsYLabel != gs.itsYLabel) {
                map.put("lbY", "" + gs.itsYLabel);
            }
            return map;
        }
        catch (Exception e) {
            System.out.println("create Graphic  Map   - 338");
            throw new StateManagerException("N\u00e3o \u00e9 poss\u00edvel mapear o GraphicState.");
        }
    }

    public Map createMap(int CID, State s) throws StateManagerException {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            int ID = CreationManager.getGraphicID(CID);
            if (ID == 5000) {
                map.put("x", new Double(((PointState)s).itsX));
                map.put("y", new Double(((PointState)s).itsY));
            } else if (ID == 5010 || ID == 5005 || ID == 5015) {
                map.put("x1", new Double(((GenericLineState)s).itsX1));
                map.put("y1", new Double(((GenericLineState)s).itsY1));
                map.put("x2", new Double(((GenericLineState)s).itsX2));
                map.put("y2", new Double(((GenericLineState)s).itsY2));
            } else if (ID == 5020) {
                map.put("centerX", new Double(((CircleState)s).itsCenterX));
                map.put("centerY", new Double(((CircleState)s).itsCenterY));
                map.put("radius", new Double(((CircleState)s).itsRadius));
            } else if (ID == 5021) {
                map.put("centerX", new Double(((CircleInteriorState)s).itsCenterX));
                map.put("centerY", new Double(((CircleInteriorState)s).itsCenterY));
                map.put("radius", new Double(((CircleInteriorState)s).itsRadius));
            } else if (ID == 5035) {
                map.put("x1", new Double(((VectorState)s).itsX1));
                map.put("y1", new Double(((VectorState)s).itsY1));
                map.put("x2", new Double(((VectorState)s).itsX2));
                map.put("y2", new Double(((VectorState)s).itsY2));
            } else if (ID == 5030) {
                map.put("angle", new Double(((AngleState)s).itsAngle));
            } else if (ID == 5031) {
                map.put("length", new Double(((LengthState)s).itsLength));
            } else if (ID == 5032) {
                map.put("area", new Double(((AreaState)s).itsArea));
            } else if (ID == 5033) {
                map.put("func", new Double(((FunctionState)s).itsValue));
            } else if (ID == 5025 || ID == 5034) {
                map.put("ratio", new Double(((RatioState)s).itsRatio));
                map.put("rdim", new Double(((RatioState)s).itsRatioDimension));
            } else if (ID == 5080) {
                map.put("product", new Double(((DotProductState)s).itsDotProduct));
            } else if (ID != 5050 && ID != 5040 && ID != 5090 && ID != 5095 && ID != 5097 && ID != 5099 && ID != 5070) {
                if (ID == 5060) {
                    map.put("x1", new Double(((TriangleState)s).itsX1));
                    map.put("y1", new Double(((TriangleState)s).itsY1));
                    map.put("x2", new Double(((TriangleState)s).itsX2));
                    map.put("y2", new Double(((TriangleState)s).itsY2));
                    map.put("x3", new Double(((TriangleState)s).itsX3));
                    map.put("y3", new Double(((TriangleState)s).itsY3));
                } else if (ID == 5085) {
                    map.put("centerX", new Double(((ArcState)s).itsCenterX));
                    map.put("centerY", new Double(((ArcState)s).itsCenterY));
                    map.put("radius", new Double(((ArcState)s).itsRadius));
                    map.put("arc", new Double(((ArcState)s).itsArcAngle));
                    map.put("startingAngle", new Double(((ArcState)s).itsStartingAngle));
                } else if (ID == 5200) {
                    map.put("x1", new Double(((AxesState)s).itsX1));
                    map.put("y1", new Double(((AxesState)s).itsY1));
                    map.put("x2", new Double(((AxesState)s).itsX2));
                    map.put("y2", new Double(((AxesState)s).itsY2));
                    map.put("x3", new Double(((AxesState)s).itsOriginX));
                    map.put("y3", new Double(((AxesState)s).itsOriginY));
                } else if (ID == 5023) {
                    map.put("centerX", new Double(((ArcInteriorSegmentState)s).itsCenterX));
                    map.put("centerY", new Double(((ArcInteriorSegmentState)s).itsCenterY));
                    map.put("radius", new Double(((ArcInteriorSegmentState)s).itsRadius));
                    map.put("arc", new Double(((ArcInteriorSegmentState)s).itsAngle));
                    map.put("startingAngle", new Double(((ArcInteriorSegmentState)s).itsStartingAngle));
                } else if (ID == 5022) {
                    map.put("centerX", new Double(((ArcInteriorSectorState)s).itsCenterX));
                    map.put("centerY", new Double(((ArcInteriorSectorState)s).itsCenterY));
                    map.put("radius", new Double(((ArcInteriorSectorState)s).itsRadius));
                    map.put("arc", new Double(((ArcInteriorSectorState)s).itsAngle));
                    map.put("startingAngle", new Double(((ArcInteriorSectorState)s).itsStartingAngle));
                } else if (ID == 5086) {
                    map.put("centerX", new Double(((CircularSectorState)s).itsCenterX));
                    map.put("centerY", new Double(((CircularSectorState)s).itsCenterY));
                    map.put("radius", new Double(((CircularSectorState)s).itsRadius));
                    map.put("angle", new Double(((CircularSectorState)s).itsAngle));
                    map.put("startingAngle", new Double(((CircularSectorState)s).itsStartingAngle));
                } else if (ID == 5087) {
                    map.put("centerX", new Double(((CircularSegmentState)s).itsCenterX));
                    map.put("centerY", new Double(((CircularSegmentState)s).itsCenterY));
                    map.put("radius", new Double(((CircularSegmentState)s).itsRadius));
                    map.put("angle", new Double(((CircularSegmentState)s).itsAngle));
                    map.put("startingAngle", new Double(((CircularSegmentState)s).itsStartingAngle));
                } else if (ID == 9050) {
                    map.put("texto", ((TextState)s).itsText);
                } else if (ID == 5110) {
                    map.put("unidade", new Double(((UnitaryMeasureState)s).itsUnitaryMeasureConstant));
                }
            }
            return map;
        }
        catch (Exception e) {
            System.out.println("create State Map   - 544");
            throw new StateManagerException("N\u00e3o \u00e9 poss\u00edvel mapear o State.");
        }
    }

    public Map toUpperCase(Map m) throws StateManagerException {
        if (m == null) {
            throw new StateManagerException("StateManager - mapa nulo");
        }
        Object[] s = m.keySet().toArray();
        HashMap ml = new HashMap();
        int len = s.length;
        try {
            int i = 0;
            while (i < len) {
                String k = (String)s[i];
                ml.put(k.toUpperCase(), m.get(k));
                ++i;
            }
        }
        catch (Exception e) {
            throw new StateManagerException("StateManager - erro de class cast");
        }
        return ml;
    }
}

