/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.tm.manager;

import br.ufrj.labma.enibam.gui.GUI;
import br.ufrj.labma.enibam.gui.window.WindowManager;
import br.ufrj.labma.enibam.history.Version;
import br.ufrj.labma.enibam.network.data.response.ResponseLastVersion;
import br.ufrj.labma.enibam.network.manager.GroupwareAdapter;
import br.xdev.framework.logging.Logger;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;

public class UpdateManager
extends Thread {
    public static final String TABULAE_UPDATE_FILE = "tabulae.update";

    public UpdateManager() {
        this.start();
    }

    @Override
    public void run() {
        Logger.debug((Object)"UpdateManager:->checando atualiza\u00e7\u00f5es....");
        if (!this.update()) {
            ResponseLastVersion response = GroupwareAdapter.getInstance().requestLastVersion();
            if (response != null) {
                String version = response.getVersion();
                Logger.debug((Object)("UpdateManager:->vers\u00e3o mais atual=[" + version + "]"));
                if (version != null && !version.trim().equals("") && !version.equals(Version.getBuild())) {
                    Logger.debug((Object)("UpdateManager:->vers\u00e3o corrente desatualizada=[" + Version.getBuild() + "]"));
                    Logger.debug((Object)("UpdateManager:->recuperar atualiza\u00e7\u00f5es=[" + version + "]"));
                    File register = new File(new File(System.getProperty("java.io.tmpdir")), TABULAE_UPDATE_FILE);
                    GroupwareAdapter.getInstance().requestVersionUpdate(response.getLength(), register);
                }
            } else {
                Logger.debug((Object)"UpdateManager:-> nenhuma atualiza\u00e7\u00e3o identificada.");
            }
        }
        Logger.debug((Object)"UpdateManager:->atividade encerrada.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean update() {
        File lib = this.getLibrary("lib//tabulae-library.jar");
        Logger.debug((Object)("verificando permiss\u00e3o de escrever na lib:" + lib));
        if (lib == null || !lib.exists() || !lib.canWrite()) {
            Logger.debug((Object)"Usu\u00e1rio n\u00e3o tem privil\u00e9gio de atualiza\u00e7\u00e3o no sistema local.");
            return true;
        }
        Logger.debug((Object)"movendo pacote de atualiza\u00e7\u00e3o para library updated...");
        File register = new File(new File(System.getProperty("java.io.tmpdir")), TABULAE_UPDATE_FILE);
        if (register == null || !register.exists() || !register.canRead()) return false;
        BufferedReader input = null;
        FileOutputStream outputFile = null;
        FileInputStream inputFile = null;
        if (!WindowManager.getInstance().showQuestionDialog2((Object)"Existe uma vers\u00e3o mais recente do Tabulae. Ap\u00f3s a atualiza\u00e7\u00e3o\n ser\u00e1 necess\u00e1rio reiniciar o Tabulae. Voc\u00ea deseja atualizar agora?", (Component)GUI.getInstance())) return true;
        try {
            try {
                File tabulaelib = null;
                input = new BufferedReader(new FileReader(register));
                String line = input.readLine();
                input.close();
                register.delete();
                if (line != null) {
                    File library = new File(line);
                    if (library.exists() && library.canRead()) {
                        tabulaelib = this.getLibrary("lib//tabulae-library.jar");
                        Logger.debug((Object)("Tentando escrever na lib:" + tabulaelib));
                        if (tabulaelib != null && (!tabulaelib.exists() || tabulaelib.exists() && library.canWrite())) {
                            this.move(library, tabulaelib);
                            String call = String.valueOf(System.getProperty("sun.boot.library.path")) + System.getProperty("file.separator") + "java";
                            call = String.valueOf(call) + " -Dsystem-property-base=\"" + System.getProperty("system-property-base") + "\"";
                            call = String.valueOf(call) + " -cp \"" + System.getProperty("java.class.path") + "\" ";
                            call = String.valueOf(call) + GUI.class.getName();
                            try {
                                Runtime.getRuntime().exec(call);
                            }
                            catch (Exception e) {
                                Logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                            System.exit(0);
                            return false;
                        }
                        WindowManager.getInstance().showAlertDialog((Object)"N\u00e3o foi poss\u00edvel atualizar sua vers\u00e3o\n porque voc\u00ea n\u00e3o tem permiss\u00e3o de escrita.", (Component)GUI.getInstance());
                        register.delete();
                        return false;
                    }
                    WindowManager.getInstance().showAlertDialog((Object)"N\u00e3o foi poss\u00edvel atualizar sua vers\u00e3o porque voc\u00ea n\u00e3o tem\n permiss\u00e3o de leitura do pacote de atualiza\u00e7\u00e3o.", (Component)GUI.getInstance());
                    register.delete();
                    return false;
                }
                WindowManager.getInstance().showAlertDialog((Object)"N\u00e3o foi poss\u00edvel atualizar sua vers\u00e3o porque\n o pacote de atualiza\u00e7\u00e3o est\u00e1 corropido.", (Component)GUI.getInstance());
                register.delete();
                return false;
            }
            catch (Exception e) {
                WindowManager.getInstance().showAlertDialog((Object)("N\u00e3o foi poss\u00edvel atualizar sua vers\u00e3o.\nProblema:" + e.getMessage()), (Component)GUI.getInstance());
                Logger.error((Object)e.getMessage(), (Throwable)e);
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e2) {
                        Logger.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                }
                if (outputFile != null) {
                    try {
                        outputFile.close();
                    }
                    catch (IOException e3) {
                        Logger.error((Object)e3.getMessage(), (Throwable)e3);
                    }
                }
                if (inputFile == null) return false;
                try {
                    inputFile.close();
                    return false;
                }
                catch (IOException e4) {
                    Logger.error((Object)e4.getMessage(), (Throwable)e4);
                }
            }
            return false;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (outputFile != null) {
                try {
                    outputFile.close();
                }
                catch (IOException e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (inputFile != null) {
                try {
                    inputFile.close();
                }
                catch (IOException e) {
                    Logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void move(File tabulaelib1, File tabulaelib2) throws FileNotFoundException, IOException {
        FileOutputStream outputFile = new FileOutputStream(tabulaelib2);
        FileInputStream inputFile = new FileInputStream(tabulaelib1);
        int index = 0;
        long iterations = tabulaelib1.length() / 5000L;
        if (tabulaelib1.length() % 5000L != 0L) {
            ++iterations;
        }
        int i = 0;
        while ((long)i < iterations) {
            byte[] data = new byte[(long)(i + 1) < iterations ? 5000 : (int)(tabulaelib1.length() % 5000L)];
            inputFile.read(data, index, data.length);
            outputFile.write(data);
            ++i;
        }
        outputFile.flush();
        inputFile.close();
        outputFile.close();
        tabulaelib1.delete();
    }

    private File getLibrary(String library_name) {
        File tabulaelib = null;
        String base = System.getProperty("system-property-base");
        if (base != null) {
            int index = base.lastIndexOf(File.separatorChar);
            if (index < 0) {
                return null;
            }
            if (index == base.length() - 1 && (index = base.substring(0, index).lastIndexOf(File.separatorChar)) < 0) {
                return null;
            }
            if ((index = base.substring(0, index).lastIndexOf(File.separatorChar)) < 0) {
                return null;
            }
            tabulaelib = new File(new File(base.substring(0, index)), library_name);
        }
        return tabulaelib;
    }
}

