/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.util;

import br.ufrj.labma.enibam.history.Version;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public final class FileAttribute {
    public static final String VERSION = "";
    public static String DATE = "";
    public static String TIME = "";
    public static final String AUTHOR = "";
    public static final String DESCRIPTION = "";
    public static final String UNDEFINED = "under version 57 DEV";
    private String version;
    private String date;
    private String time;
    private String author;
    private String description = "";
    private static final String VERSION_KEY = "version";
    private static final String DATE_KEY = "date";
    private static final String TIME_KEY = "time";
    private static final String AUTHOR_KEY = "author";
    private static final String DESCRIPTION_KEY = "description";

    public FileAttribute() {
        this(Version.getBuild());
    }

    public FileAttribute(String v) {
        this(v, DATE, "");
    }

    public FileAttribute(FileAttribute f) {
        this(Version.getBuild(), f.getDate(), f.getAuthor());
        this.setDescription(f.getDescription());
    }

    public FileAttribute(String v, String d, String a) {
        this.version = v == null || v == "" ? UNDEFINED : v;
        this.formatTimestamp();
        this.date = DATE;
        this.time = TIME;
        this.author = a;
    }

    public String toString() {
        return "FileAttribute [version=" + this.version + ",date=" + this.date + ",author=" + this.author + "]";
    }

    public String getVersion() {
        return this.version;
    }

    public String getDate() {
        return this.date;
    }

    public String getTime() {
        return this.time;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public Map getMapStream() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(VERSION_KEY, this.version);
        map.put(DATE_KEY, this.date);
        map.put(TIME_KEY, this.time);
        map.put(AUTHOR_KEY, this.author);
        map.put(DESCRIPTION_KEY, this.description);
        return map;
    }

    public boolean setMapStream(Map map) {
        if (map == null) {
            return false;
        }
        this.formatTimestamp();
        try {
            this.version = (String)map.get(VERSION_KEY);
            if (this.version == null) {
                this.version = UNDEFINED;
            }
        }
        catch (Exception e) {
            this.version = UNDEFINED;
        }
        try {
            this.date = (String)map.get(DATE_KEY);
            if (this.date == null) {
                this.date = DATE;
            }
        }
        catch (Exception e) {
            this.date = DATE;
        }
        try {
            this.time = (String)map.get(TIME_KEY);
            if (this.time == null) {
                this.time = TIME;
            }
        }
        catch (Exception e) {
            this.time = TIME;
        }
        try {
            this.author = (String)map.get(AUTHOR_KEY);
            if (this.author == null) {
                this.author = "";
            }
        }
        catch (Exception e) {
            this.author = "";
        }
        try {
            this.description = (String)map.get(DESCRIPTION_KEY);
            if (this.description == null) {
                this.description = "";
            }
        }
        catch (Exception e) {
            this.description = "";
        }
        return true;
    }

    private void formatTimestamp() {
        DATE = "";
        int value = Calendar.getInstance().get(5);
        DATE = String.valueOf(DATE) + (value < 10 ? "0" + value : String.valueOf(value));
        DATE = String.valueOf(DATE) + "/";
        value = Calendar.getInstance().get(2) + 1;
        DATE = String.valueOf(DATE) + (value < 10 ? "0" + value : String.valueOf(value));
        DATE = String.valueOf(DATE) + "/";
        value = Calendar.getInstance().get(1);
        DATE = String.valueOf(DATE) + (value < 10 ? "0" + value : String.valueOf(value));
        TIME = "";
        value = Calendar.getInstance().get(11);
        TIME = String.valueOf(TIME) + (value < 10 ? "0" + value : String.valueOf(value));
        TIME = String.valueOf(TIME) + ":";
        value = Calendar.getInstance().get(12);
        TIME = String.valueOf(TIME) + (value < 10 ? "0" + value : String.valueOf(value));
        TIME = String.valueOf(TIME) + ":";
        value = Calendar.getInstance().get(13);
        TIME = String.valueOf(TIME) + (value < 10 ? "0" + value : String.valueOf(value));
    }
}

