/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.util;

import java.util.HashMap;
import java.util.Map;

public final class GraphicAttribute {
    public static final int WIDTH = 10000;
    public static final int HEIGHT = 10000;
    public static final int XSOURCE = 5000;
    public static final int YSOURCE = 5000;
    public static final int XOFFSET = 4700;
    public static final int YOFFSET = 4700;
    public static final double ZOOM = 1.0;
    private int width;
    private int height;
    private int offsetX;
    private int offsetY;
    private int xsource;
    private int ysource;
    private double zoom;
    private static final transient String WIDTH_KEY = "width";
    private static final transient String HEIGHT_KEY = "height";
    private static final transient String XOFFSET_KEY = "xoffset";
    private static final transient String YOFFSET_KEY = "yoffset";
    private static final transient String XSOURCE_KEY = "xsource";
    private static final transient String YSOURCE_KEY = "ysource";
    private static final transient String ZOOM_KEY = "zoom";

    public GraphicAttribute() {
        this(10000, 10000, 0, 0, 5000, 5000, 1.0);
    }

    public GraphicAttribute(int width, int height) {
        this(width, height, 0, 0, width / 2, height / 2, 1.0);
    }

    public GraphicAttribute(int width, int height, int x, int y) {
        this(width, height, x, y, width / 2, height / 2, 1.0);
    }

    public GraphicAttribute(int width, int height, int x, int y, int xs, int ys, double z) {
        this.width = width;
        this.height = height;
        this.offsetX = x;
        this.offsetY = y;
        this.xsource = xs;
        this.ysource = ys;
        this.zoom = z;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getXOffset() {
        return this.offsetX;
    }

    public int getYOffset() {
        return this.offsetY;
    }

    public int getXSource() {
        return this.xsource;
    }

    public int getYSource() {
        return this.ysource;
    }

    public double getZoom() {
        return this.zoom;
    }

    public Map getMapStream() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(WIDTH_KEY, "" + this.width);
        map.put(HEIGHT_KEY, "" + this.height);
        map.put(XOFFSET_KEY, "" + this.offsetX);
        map.put(YOFFSET_KEY, "" + this.offsetY);
        map.put(XSOURCE_KEY, "" + this.xsource);
        map.put(YSOURCE_KEY, "" + this.ysource);
        map.put(ZOOM_KEY, "" + this.zoom);
        return map;
    }

    public boolean setMapStream(Map map) {
        if (map == null) {
            return false;
        }
        try {
            this.width = Integer.parseInt((String)map.get(WIDTH_KEY));
        }
        catch (Exception e) {
            this.width = 10000;
        }
        try {
            this.height = Integer.parseInt((String)map.get(HEIGHT_KEY));
        }
        catch (Exception e) {
            this.height = 10000;
        }
        try {
            this.offsetX = Integer.parseInt((String)map.get(XOFFSET_KEY));
        }
        catch (Exception e) {
            this.offsetX = 4700;
        }
        try {
            this.offsetY = Integer.parseInt((String)map.get(YOFFSET_KEY));
        }
        catch (Exception e) {
            this.offsetY = 4700;
        }
        try {
            this.xsource = Integer.parseInt((String)map.get(XSOURCE_KEY));
        }
        catch (Exception e) {
            this.xsource = 5000;
        }
        try {
            this.ysource = Integer.parseInt((String)map.get(YSOURCE_KEY));
        }
        catch (Exception e) {
            this.ysource = 5000;
        }
        try {
            this.zoom = Double.parseDouble((String)map.get(ZOOM_KEY));
        }
        catch (Exception e) {
            this.zoom = 1.0;
        }
        return true;
    }

    public String toString() {
        return "GraphicAttribute [width=" + this.width + ",height=" + this.height + ",xoffset=" + this.offsetX + ",yoffset=" + this.offsetY + ",xsource=" + this.xsource + ",ysource=" + this.ysource + ", zoom=" + this.zoom + "]";
    }
}

