/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.util;

import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.URL;
import java.util.PropertyResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.UIManager;

public abstract class GraphicUtilities {
    public static final Font CALCULATOR_FONT_BUTTON = new Font("Arial", 1, 12);
    private static double XResolution;
    private static double YResolution;
    public static final double DPI_CONST = 2.54;
    private static int DPI_VALUE;

    static {
        DPI_VALUE = 72;
    }

    public static final String ColorToHexa(Color c) {
        if (c == null) {
            return "FFFFFF";
        }
        String str = "";
        str = String.valueOf(str) + (c.getRed() < 16 ? "0" : "");
        str = String.valueOf(str) + Integer.toHexString(c.getRed());
        str = String.valueOf(str) + (c.getGreen() < 16 ? "0" : "");
        str = String.valueOf(str) + Integer.toHexString(c.getGreen());
        str = String.valueOf(str) + (c.getBlue() < 16 ? "0" : "");
        str = String.valueOf(str) + Integer.toHexString(c.getBlue());
        return str.toUpperCase();
    }

    public static final Color HexaToColor(String color) {
        if (color == null || color.length() != 6 && color.length() != 8) {
            return Color.black;
        }
        int index = 0;
        if (color.length() == 8 && (color.startsWith("0x", index) || color.startsWith("0X", index))) {
            index += 2;
        }
        try {
            int r = Integer.parseInt(color.substring(index, index + 2), 16);
            int g = Integer.parseInt(color.substring(index + 2, index + 4), 16);
            int b = Integer.parseInt(color.substring(index + 4, index + 6), 16);
            return new Color(r, g, b);
        }
        catch (NumberFormatException e) {
            return Color.black;
        }
    }

    public static final Image channelsRGB(Image img, String channel, boolean isOpaque) {
        ImageIcon icon = new ImageIcon(img);
        JLabel label = new JLabel();
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        int[] pixels = new int[w * h];
        int[] rpixels = new int[w * h];
        int[] gpixels = new int[w * h];
        int[] bpixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(icon.getImage(), 0, 0, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Color transparency = new Color(pixels[0], true);
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                Color p = new Color(pixels[j * w + i], true);
                if (isOpaque || !transparency.equals(p)) {
                    float f1 = (float)((double)p.getRed() / 255.0);
                    float f2 = (float)((double)p.getGreen() / 255.0);
                    float f3 = (float)((double)p.getBlue() / 255.0);
                    Color c = new Color(f1, 0.0f, 0.0f);
                    rpixels[j * w + i] = c.getRGB();
                    c = new Color(0.0f, f2, 0.0f);
                    gpixels[j * w + i] = c.getRGB();
                    c = new Color(0.0f, 0.0f, f3);
                    bpixels[j * w + i] = c.getRGB();
                }
                ++j;
            }
            ++i;
        }
        if (channel.equalsIgnoreCase("RED")) {
            return label.createImage(new MemoryImageSource(w, h, rpixels, 0, w));
        }
        if (channel.equalsIgnoreCase("GREEN")) {
            return label.createImage(new MemoryImageSource(w, h, gpixels, 0, w));
        }
        return label.createImage(new MemoryImageSource(w, h, bpixels, 0, w));
    }

    public static final Image grayScale(Image img, boolean isOpaque) {
        ImageIcon icon = new ImageIcon(img);
        JLabel label = new JLabel();
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(icon.getImage(), 0, 0, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Color transparency = new Color(pixels[0], true);
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                Color p = new Color(pixels[j * w + i], true);
                if (isOpaque || !transparency.equals(p)) {
                    float f = (float)(0.222 * (double)p.getRed() + 0.707 * (double)p.getGreen() + 0.071 * (double)p.getBlue()) / 255.0f;
                    Color c = new Color(f, f, f);
                    pixels[j * w + i] = c.getRGB();
                }
                ++j;
            }
            ++i;
        }
        return label.createImage(new MemoryImageSource(w, h, pixels, 0, w));
    }

    public static final Image colorScale(Image image, Color color, boolean isOpaque) {
        ImageIcon icon = new ImageIcon(image);
        JLabel label = new JLabel();
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(icon.getImage(), 0, 0, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        int f = GraphicUtilities.grayMax(pixels, isOpaque);
        Color transparency = new Color(pixels[0], true);
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                Color p = new Color(pixels[j * w + i], true);
                if (isOpaque || !transparency.equals(p)) {
                    pixels[j * w + i] = GraphicUtilities.exchangeColor(p, color, f).getRGB();
                }
                ++j;
            }
            ++i;
        }
        return label.createImage(new MemoryImageSource(w, h, pixels, 0, w));
    }

    public static final Image blackAndWhite(Image img, boolean isOpaque) {
        ImageIcon icon = new ImageIcon(img);
        JLabel label = new JLabel();
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(icon.getImage(), 0, 0, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Color transparency = new Color(pixels[0], true);
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                Color p = new Color(pixels[j * w + i], true);
                if (isOpaque || !transparency.equals(p)) {
                    float f = (float)(0.222 * (double)p.getRed() + 0.707 * (double)p.getGreen() + 0.071 * (double)p.getBlue()) / 255.0f;
                    f = (double)f > 0.5 ? 1.0f : 0.0f;
                    Color c = new Color(f, f, f);
                    pixels[j * w + i] = c.getRGB();
                }
                ++j;
            }
            ++i;
        }
        return label.createImage(new MemoryImageSource(w, h, pixels, 0, w));
    }

    public static final Image invertColor(Image img, boolean isOpaque) {
        ImageIcon icon = new ImageIcon(img);
        JLabel label = new JLabel();
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(icon.getImage(), 0, 0, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Color transparency = new Color(pixels[0], true);
        int i = 0;
        while (i < w) {
            int j = 0;
            while (j < h) {
                Color p = new Color(pixels[j * w + i], true);
                if (isOpaque || !transparency.equals(p)) {
                    float r = (float)((double)(p.getRed() ^ 0xFF) / 255.0);
                    float g = (float)((double)(p.getGreen() ^ 0xFF) / 255.0);
                    float b = (float)((double)(p.getBlue() ^ 0xFF) / 255.0);
                    Color c = new Color(r, g, b);
                    pixels[j * w + i] = c.getRGB();
                }
                ++j;
            }
            ++i;
        }
        return label.createImage(new MemoryImageSource(w, h, pixels, 0, w));
    }

    private static final int grayMax(int[] pixels, boolean isOpaque) {
        int soma = 0;
        int length = 0;
        int i = 0;
        while (i < pixels.length) {
            int value = pixels[i] >> 16 & 0xFF;
            if (isOpaque || pixels[i] != pixels[0]) {
                soma += value;
                ++length;
            }
            ++i;
        }
        if (length != 0) {
            soma /= length;
        }
        return soma == 0 ? 1 : soma;
    }

    private static final Color exchangeColor(Color myColor, Color newColor, int grayMin) {
        float factor = (float)myColor.getRed() / (float)grayMin;
        float r = factor * (float)newColor.getRed() / 255.0f;
        float g = factor * (float)newColor.getGreen() / 255.0f;
        float b = factor * (float)newColor.getBlue() / 255.0f;
        if ((double)r > 1.0) {
            r = 1.0f;
        }
        if ((double)g > 1.0) {
            g = 1.0f;
        }
        if ((double)b > 1.0) {
            b = 1.0f;
        }
        return new Color(r, g, b);
    }

    public static final void desktopToStream(CoorSys coorsys) {
        coorsys.itsX /= XResolution;
        coorsys.itsY /= YResolution;
    }

    public static final double desktopToStreamX(double x) {
        return x / XResolution;
    }

    public static final double desktopToStreamY(double y) {
        return y / YResolution;
    }

    public static final void streamToDesktop(CoorSys coorsys) {
        coorsys.itsX *= XResolution;
        coorsys.itsY *= YResolution;
    }

    public static final double streamToDesktopX(double x) {
        return x * XResolution;
    }

    public static final double streamToDesktopY(double y) {
        return y * YResolution;
    }

    public static final void loadScreenDimension() {
        XResolution = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        YResolution = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
    }

    public static final double getXResolution() {
        return XResolution;
    }

    public static final double getYResolution() {
        return YResolution;
    }

    public static double kernelToCentimeter(double x) {
        return x / (double)DPI_VALUE * 2.54;
    }

    public static double getConst() {
        return (double)DPI_VALUE / 2.54;
    }

    public static void setDPI(int dpi) {
        DPI_VALUE = dpi;
    }

    public static final void internationalizeTabulae() {
        try {
            URL url = ClassLoader.getSystemResource("include/metalae.pro");
            PropertyResourceBundle RB = new PropertyResourceBundle(url.openStream());
            UIManager.put("FileChooser.lookInLabelText", RB.getString("FileChooser.lookInLabelText"));
            UIManager.put("FileChooser.fileNameLabelText", RB.getString("FileChooser.fileNameLabelText"));
            UIManager.put("FileChooser.filesOfTypeLabelText", RB.getString("FileChooser.filesOfTypeLabelText"));
            UIManager.put("FileChooser.upFolderToolTipText", RB.getString("FileChooser.upFolderToolTipText"));
            UIManager.put("FileChooser.upFolderAccessibleName", RB.getString("FileChooser.upFolderAccessibleName"));
            UIManager.put("FileChooser.homeFolderToolTipText", RB.getString("FileChooser.homeFolderToolTipText"));
            UIManager.put("FileChooser.homeFolderAccessibleName", RB.getString("FileChooser.homeFolderAccessibleName"));
            UIManager.put("FileChooser.newFolderToolTipText", RB.getString("FileChooser.newFolderToolTipText"));
            UIManager.put("FileChooser.newFolderAccessibleNam", RB.getString("FileChooser.newFolderAccessibleNam"));
            UIManager.put("FileChooser.listViewButtonToolTipText", RB.getString("FileChooser.listViewButtonToolTipText"));
            UIManager.put("FileChooser.listViewButtonAccessibleName", RB.getString("FileChooser.listViewButtonAccessibleName"));
            UIManager.put("FileChooser.detailsViewButtonToolTipText", RB.getString("FileChooser.detailsViewButtonToolTipText"));
            UIManager.put("FileChooser.detailsViewButtonAccessibleName", RB.getString("FileChooser.detailsViewButtonAccessibleName"));
            UIManager.put("FileChooser.fileDescriptionText", RB.getString("FileChooser.fileDescriptionText"));
            UIManager.put("FileChooser.directoryDescriptionText", RB.getString("FileChooser.directoryDescriptionText"));
            UIManager.put("FileChooser.newFolderErrorText", RB.getString("FileChooser.newFolderErrorText"));
            UIManager.put("FileChooser.newFolderErrorSeparator", RB.getString("FileChooser.newFolderErrorSeparator"));
            UIManager.put("FileChooser.acceptAllFileFilterText", RB.getString("FileChooser.acceptAllFileFilterText"));
            UIManager.put("FileChooser.cancelButtonText", RB.getString("FileChooser.cancelButtonText"));
            UIManager.put("FileChooser.saveButtonText", RB.getString("FileChooser.saveButtonText"));
            UIManager.put("FileChooser.openButtonText", RB.getString("FileChooser.openButtonText"));
            UIManager.put("FileChooser.updateButtonText", RB.getString("FileChooser.updateButtonText"));
            UIManager.put("FileChooser.helpButtonText", RB.getString("FileChooser.helpButtonText"));
            UIManager.put("FileChooser.cancelButtonToolTipText", RB.getString("FileChooser.cancelButtonToolTipText"));
            UIManager.put("FileChooser.saveButtonToolTipText", RB.getString("FileChooser.saveButtonToolTipText"));
            UIManager.put("FileChooser.openButtonToolTipText", RB.getString("FileChooser.openButtonToolTipText"));
            UIManager.put("FileChooser.updateButtonToolTipText", RB.getString("FileChooser.updateButtonToolTipText"));
            UIManager.put("FileChooser.helpButtonToolTipText", RB.getString("FileChooser.helpButtonToolTipText"));
            UIManager.put("OptionPane.yesButtonText", RB.getString("OptionPane.yesButtonText"));
            UIManager.put("OptionPane.noButtonText", RB.getString("OptionPane.noButtonText"));
            UIManager.put("OptionPane.okButtonText", RB.getString("OptionPane.okButtonText"));
            UIManager.put("OptionPane.cancelButtonText", RB.getString("OptionPane.cancelButtonText"));
            UIManager.put("FileChooser.filesOfTypeLabelMnemonic", new Integer(RB.getString("FileChooser.filesOfTypeLabelMnemonic").charAt(0)));
            UIManager.put("FileChooser.fileNameLabelMnemonic", new Integer(RB.getString("FileChooser.fileNameLabelMnemonic").charAt(0)));
            UIManager.put("FileChooser.lookInLabelMnemonic", new Integer(RB.getString("FileChooser.lookInLabelMnemonic").charAt(0)));
            UIManager.put("FileChooser.openButtonMnemonic", new Integer(RB.getString("FileChooser.openButtonMnemonic").charAt(0)));
            UIManager.put("FileChooser.cancelButtonMnemonic", new Integer(RB.getString("FileChooser.cancelButtonMnemonic").charAt(0)));
            UIManager.put("OptionPane.yesButtonMnemonic", new Integer(RB.getString("OptionPane.yesButtonMnemonic").charAt(0)));
            UIManager.put("OptionPane.noButtonMnemonic", new Integer(RB.getString("OptionPane.noButtonMnemonic").charAt(0)));
            UIManager.put("OptionPane.okButtonMnemonic", new Integer(RB.getString("OptionPane.okButtonMnemonic").charAt(0)));
            UIManager.put("OptionPane.cancelButtonMnemonic", new Integer(RB.getString("OptionPane.cancelButtonMnemonic").charAt(0)));
        }
        catch (Exception e) {
            System.out.println("Load Resource File=>" + e);
            return;
        }
    }

    public static final String roundValue(double x, int precision) {
        int t;
        int inteiro = 1;
        int pow = (int)Math.pow(10.0, precision);
        double npow = Math.pow(10.0, -(precision + 1));
        if (x < 0.0) {
            t = (int)(Math.abs((x -= 5.0 * npow) - Math.ceil(x)) * (double)pow);
            inteiro = Math.abs((int)Math.ceil(x));
        } else {
            t = (int)(Math.abs((x += 5.0 * npow) - Math.floor(x)) * (double)pow);
            inteiro = (int)Math.floor(x);
        }
        String k = "";
        int j = 0;
        while (j < precision) {
            String ch = "" + t % 10;
            k = String.valueOf(ch) + k;
            t /= 10;
            ++j;
        }
        String sig = x < 0.0 ? "-" : "";
        return String.valueOf(sig) + inteiro + "." + k;
    }
}

