/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.util;

import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import java.io.Serializable;

public class MathVector
implements Serializable {
    private double itsX;
    private double itsY;

    public MathVector() {
        this.itsY = 0.0;
        this.itsX = 0.0;
    }

    public MathVector(MathVector a) {
        this.itsX = a.getX();
        this.itsY = a.getY();
    }

    public MathVector(CoorSys a, CoorSys b) {
        this.itsX = b.itsX - a.itsX;
        this.itsY = b.itsY - a.itsY;
    }

    public MathVector(double a, double b) {
        this.itsX = a;
        this.itsY = b;
    }

    public MathVector(double x1, double y1, double x2, double y2) {
        this.itsX = x2 - x1;
        this.itsY = y2 - y1;
    }

    public double getX() {
        return this.itsX;
    }

    public double getY() {
        return this.itsY;
    }

    public void setX(double s) {
        this.itsX = s;
    }

    public void setY(double s) {
        this.itsY = s;
    }

    public void setXY(double s, double z) {
        this.itsX = s;
        this.itsY = z;
    }

    public void setVector(MathVector u) {
        this.itsX = u.getX();
        this.itsY = u.getY();
    }

    public void setVector(CoorSys c) {
        this.itsX = c.itsX;
        this.itsY = c.itsY;
    }

    public void setVector(CoorSys a, CoorSys b) {
        this.itsX = b.itsX - a.itsX;
        this.itsY = b.itsY - a.itsY;
    }

    public void setVector(double x1, double y1, double x2, double y2) {
        this.itsX = x2 - x1;
        this.itsY = y2 - y1;
    }

    public double modulus() {
        return Math.sqrt(this.itsX * this.itsX + this.itsY * this.itsY);
    }

    public double angle(MathVector m) {
        return Math.acos(this.produto_interno(m) / (this.modulus() * m.modulus()));
    }

    public double produto_interno(MathVector u) {
        return this.itsX * u.getX() + this.itsY * u.getY();
    }

    public double determinant(MathVector u) {
        return this.itsX * u.getY() - this.itsY * u.getX();
    }

    public MathVector unitario() {
        double _a = this.modulus();
        this.itsX /= _a;
        this.itsY /= _a;
        return this;
    }

    public MathVector newUnitario() {
        double _a = this.modulus();
        return new MathVector(this.itsX / _a, this.itsY / _a);
    }

    public MathVector productByNumber(double s) {
        this.itsX *= s;
        this.itsY *= s;
        return this;
    }

    public MathVector newProductByNumber(double s) {
        return new MathVector(this.itsX * s, this.itsY * s);
    }

    public MathVector addition(MathVector v) {
        this.itsX += v.getX();
        this.itsY += v.getY();
        return this;
    }

    public MathVector newAddition(MathVector v) {
        return new MathVector(this.itsX + v.getX(), this.itsY + v.getY());
    }

    public void sum(MathVector v) {
        this.itsX += v.getX();
        this.itsY += v.getY();
    }

    public MathVector sub(MathVector v) {
        this.itsX -= v.getX();
        this.itsY -= v.getY();
        return this;
    }

    public MathVector newSub(MathVector v) {
        return new MathVector(this.itsX - v.getX(), this.itsY - v.getY());
    }

    public MathVector rotation(double angle) {
        double novoX = this.itsX * Math.cos(angle) - this.itsY * Math.sin(angle);
        double novoY = this.itsY * Math.cos(angle) + this.itsX * Math.sin(angle);
        this.itsX = novoX;
        this.itsY = novoY;
        return this;
    }

    public MathVector newRotation(double angle) {
        return new MathVector(this.itsX * Math.cos(angle) - this.itsY * Math.sin(angle), this.itsY * Math.cos(angle) + this.itsX * Math.sin(angle));
    }

    public MathVector orthogonal() {
        double _tmp = this.itsX;
        this.itsX = -this.itsY;
        this.itsY = _tmp;
        return this;
    }

    public MathVector newOrthogonal() {
        return new MathVector(-this.itsY, this.itsX);
    }

    public MathVector theOpposite() {
        this.itsX = -this.itsX;
        return this;
    }

    public MathVector newOpposite() {
        return new MathVector(-this.itsX, this.itsY);
    }

    public double theArea(MathVector u) {
        return Math.abs(this.determinant(u));
    }

    public boolean theVectorNull() {
        return this.itsX == 0.0 && this.itsY == 0.0;
    }

    public void negative() {
        this.itsX = -this.itsX;
        this.itsY = -this.itsY;
    }

    public boolean vertical() {
        return this.itsX == 0.0;
    }

    public boolean horizontal() {
        return this.itsY == 0.0;
    }

    public boolean equal(MathVector u) {
        return u.getX() == this.itsX && u.getY() == this.itsY;
    }

    public boolean isParallel(MathVector u) {
        double _ux = u.getX();
        double _uy = u.getY();
        if (this.itsX == 0.0 && this.itsY == 0.0) {
            return false;
        }
        if (_ux == 0.0 && _uy == 0.0) {
            return false;
        }
        if (_ux != 0.0 && _uy != 0.0) {
            double tx = this.itsX / _ux;
            double ty = this.itsY / _uy;
            return tx == ty;
        }
        if (_ux == 0.0) {
            return this.itsX == 0.0;
        }
        if (_uy == 0.0) {
            return this.itsY == 0.0;
        }
        return true;
    }
}

