/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.video;

import br.ufrj.labma.enibam.tm.manager.ConfigurationManager;
import java.awt.Dimension;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullBufferStream;

public class ImageSourceStream
implements PullBufferStream {
    Vector images;
    int width;
    int height;
    VideoFormat format;
    int nextImage = 0;
    boolean ended = false;

    public ImageSourceStream(int width, int height, float frameRate, Vector images) {
        this.width = width;
        this.height = height;
        this.images = images;
        this.format = new VideoFormat(ConfigurationManager.getInstance().CS.VIDEO_FORMAT, new Dimension(width, height), -1, Format.byteArray, frameRate);
    }

    public boolean willReadBlock() {
        return false;
    }

    public void read(Buffer buf) throws IOException {
        if (this.nextImage >= this.images.size()) {
            System.err.println("Done reading all images.");
            buf.setEOM(true);
            buf.setOffset(0);
            buf.setLength(0);
            this.ended = true;
            return;
        }
        String imageFile = this.images.elementAt(this.nextImage).toString();
        ++this.nextImage;
        System.err.println("  - reading image file: " + imageFile);
        RandomAccessFile raFile = new RandomAccessFile(imageFile, "r");
        byte[] data = null;
        if (buf.getData() instanceof byte[]) {
            data = (byte[])buf.getData();
        }
        if (data == null || (long)data.length < raFile.length()) {
            data = new byte[(int)raFile.length()];
            buf.setData((Object)data);
        }
        raFile.readFully(data, 0, (int)raFile.length());
        System.err.println("    read " + raFile.length() + " bytes.");
        buf.setOffset(0);
        buf.setLength((int)raFile.length());
        buf.setFormat((Format)this.format);
        buf.setFlags(buf.getFlags() | 0x10);
        raFile.close();
    }

    public Format getFormat() {
        return this.format;
    }

    public ContentDescriptor getContentDescriptor() {
        return new ContentDescriptor("raw");
    }

    public long getContentLength() {
        return 0L;
    }

    public boolean endOfStream() {
        return this.ended;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String type) {
        return null;
    }
}

