/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.video;

import br.ufrj.labma.enibam.tm.manager.ConfigurationManager;
import br.ufrj.labma.enibam.video.ImageDataSource;
import br.ufrj.labma.enibam.video.TabulaeControllerListener;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Processor;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.FileTypeDescriptor;

public class TabulaeVideo
extends Thread {
    private DataSource output;
    private DataSink datasink = null;
    private File outputmovie = null;
    private List sourceFileList = null;
    private Dimension dimension = null;

    @Override
    public void run() {
        Vector kas = new Vector();
        int i = 0;
        while (i < this.sourceFileList.size()) {
            kas.addElement(this.sourceFileList.get(i));
            ++i;
        }
        ImageDataSource oi = new ImageDataSource((int)this.dimension.getWidth(), (int)this.dimension.getHeight(), ConfigurationManager.getInstance().CS.VIDEO_FRAME_RATE, kas);
        try {
            Processor pro = Manager.createProcessor((DataSource)oi);
            pro.addControllerListener((ControllerListener)new TabulaeControllerListener(this, pro));
            pro.configure();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void criarVideoPorImagem(List files, Dimension dimension, File outputmovie) {
        this.start();
        this.outputmovie = outputmovie;
        this.sourceFileList = files;
        this.dimension = dimension;
    }

    void processConfigureCompleteEvent(Processor pro) {
        pro.setContentDescriptor((ContentDescriptor)new FileTypeDescriptor(ConfigurationManager.getInstance().CS.VIDEO_FILE_TYPE));
        pro.realize();
    }

    void processRealizeCompleteEvent(Processor pro) {
        this.output = pro.getDataOutput();
        try {
            this.datasink = Manager.createDataSink((DataSource)this.output, (MediaLocator)new MediaLocator(this.outputmovie.toURL()));
            this.datasink.open();
            this.datasink.start();
            pro.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void processEndOfMediaEvent(Processor pro) {
        pro.stop();
        try {
            this.datasink.stop();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        pro.close();
        this.datasink.close();
        this.output.disconnect();
        this.removeTempImages();
    }

    private final void removeTempImages() {
        if (this.sourceFileList != null) {
            Iterator i = this.sourceFileList.iterator();
            while (i.hasNext()) {
                try {
                    ((File)i.next()).delete();
                }
                catch (Exception e) {
                    System.out.println("N\u00e3o foi poss\u00edvel remover o arquivo tempor\u00e1rio.");
                }
            }
        }
    }
}

